## Работа с самозанятыми

Самозанятые — это люди, которые не имеют работодателя и наемных работников и получают доход, оказывая услуги или продавая товары собственного производства. При выплатах самозанятым каждая выплата будет считаться доходом самозанятого, и ЮKassa будет автоматически регистрировать ее в сервисе «[Мой налог](https://lknpd.nalog.ru/)».

Информация о самозанятом нужна для проведения выплат самозанятым. [Как делать выплаты самозанятым](https://yookassa.ru/developers/payouts/scenario-extensions/self-employed)

SDK позволяет создавать самозанятого в ЮKassa, а также получать о нем информацию.

Объект самозанятого `SelfEmployed` содержит всю информацию о самозанятом, актуальную на текущий момент времени. Объект формируется при создании самозанятого и приходит в ответ на любой запрос, связанный с самозанятым.

Набор возвращаемых параметров зависит от статуса объекта (значение параметра `status`) и того, какие параметры вы передали в запросе на создание самозанятого.

* [Запрос на создание самозанятого](#Запрос-на-создание-самозанятого)
* [Получить информацию о самозанятом](#Получить-информацию-о-самозанятом)

---

### Запрос на создание самозанятого <a name="Запрос-на-создание-самозанятого"></a>

Используйте этот запрос, чтобы создать в ЮKassa объект самозанятого. В запросе необходимо передать ИНН или телефон самозанятого для идентификации в сервисе «Мой налог», сценарий подтверждения пользователем заявки ЮMoney на получение прав для регистрации чеков и описание самозанятого.

Идентификатор созданного объекта самозанятого необходимо использовать в запросе на проведение выплаты.

В ответ на запрос придет объект самозанятого — `SelfEmployedResponse` — в актуальном статусе.

```php
require_once 'vendor/autoload.php';

$client = new \YooKassa\Client();
$client->setAuth('xxxxxx', 'test_XXXXXXX');

$request = [
    'itn' => '123456789012',
    'phone' => '79001002030',
    'confirmation' => [
        'type' => 'redirect'
    ],
];
$idempotenceKey = uniqid('', true);
try {
    $result = $client->createSelfEmployed($request, $idempotenceKey);
} catch (\Exception $e) {
    $result = $e;
}

var_dump($result);
```
---

### Получить информацию о самозанятом <a name="Получить-информацию-о-самозанятом"></a>

С помощью этого запроса вы можете получить информацию о текущем статусе самозанятого по его уникальному идентификатору.

В ответ на запрос придет объект самозанятого — `SelfEmployedResponse` — в актуальном статусе.

```php
require_once 'vendor/autoload.php';

$client = new \YooKassa\Client();
$client->setAuth('xxxxxx', 'test_XXXXXXX');

$selfEmployedId = 'se-285c0ab7-0003-5000-9000-0e1166498fda';
try {
    $response = $client->getSelfEmployedInfo($selfEmployedId);
} catch (\Exception $e) {
    $response = $e;
}

var_dump($response);
```
