<?php
/**
* Component : Contact
* Controller : ContactGroupController
* File : group.list.blade.php
----------------------------------------------------------------------------- */
?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('users.partials.header', [
'title' => __tr('Contact Groups'),
'description' => '',
'class' => 'col-lg-7'
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $status = request()->status ?? 'active'; ?>

<div class="container-fluid mt-lg--6">
    <div class="row">
        <!-- button -->
        <div class="col-xl-12 mb-3">
            <button type="button" class="lw-btn btn btn-primary float-right" data-toggle="modal"
                data-target="#lwAddNewGroup"> <?php echo e(__tr('Add New Group')); ?></button>
        </div>
        <!--/ button -->
        <div class="col-xl-12" x-cloak x-data="{isSelectedAll:false,selectedContacts: [],selectedGroupsForSelectedContacts:[],
        toggle(id) {
            if (this.selectedContacts.includes(id)) {
                const index = this.selectedContacts.indexOf(id);
                this.selectedContacts.splice(index, 1);
                this.isSelectedAll = false;
            } else {
                this.selectedContacts.push(id);
                if($('.dataTables_wrapper table>tbody input[type=checkbox].lw-checkboxes').length == this.selectedContacts.length) {
                    this.isSelectedAll = true;
                }
            };
        },toggleAll() {
            if(!this.isSelectedAll) {
                $('.dataTables_wrapper table>tbody input[type=checkbox].lw-checkboxes').not(':checked').trigger('click');
                this.isSelectedAll = true;
            } else {
                $('.dataTables_wrapper table>tbody input[type=checkbox].lw-checkboxes:checked').trigger('click');
                this.isSelectedAll = false;
            }
        },deleteSelectedContactGroups() {
            var that = this;
            showConfirmation('<?php echo e(__tr('Are you sure you want to delete all selected groups?')); ?>', function() {
                __DataRequest.post('<?php echo e(route('vendor.contact.group.selected.write.delete')); ?>', {
                    'selected_groups' : that.selectedContacts
                });
            }, {
                confirmButtonText: '<?php echo e(__tr('Yes')); ?>',
                cancelButtonText: '<?php echo e(__tr('No')); ?>',
                type: 'error'
            });
        },
        archiveSelectedContactGroups() {
            var that = this;
            showConfirmation('<?php echo e(__tr('Are you sure you want to archive all selected groups?')); ?>', function() {
                __DataRequest.post('<?php echo e(route('vendor.contact.group.selected.write.archive')); ?>', {
                    'selected_groups' : that.selectedContacts
                });
            }, {
                confirmButtonText: '<?php echo e(__tr('Yes')); ?>',
                cancelButtonText: '<?php echo e(__tr('No')); ?>',
                type: 'warning'
            });
        },
        unarchiveSelectedContactGroups() {
            var that = this;
            showConfirmation('<?php echo e(__tr('Are you sure you want to unarchive all selected groups?')); ?>', function() {
                __DataRequest.post('<?php echo e(route('vendor.contact.group.selected.write.unarchive')); ?>', {
                    'selected_groups' : that.selectedContacts
                });
            }, {
                confirmButtonText: '<?php echo e(__tr('Yes')); ?>',
                cancelButtonText: '<?php echo e(__tr('No')); ?>',
                type: 'warning'
            });
        },
            }
        " x-init="$('#lwGroupList').on( 'draw.dt', function () {
            $('.dataTables_wrapper table>tbody input[type=checkbox].lw-checkboxes:checked').trigger('click');
            isSelectedAll = false;
        } );">
            <ul class="nav nav-tabs mt-1 ml-1">
                <!-- Active tab -->
                <li class="nav-item">
                    <a class="nav-link <?= $status == 'active' ? 'active' : '' ?>" data-title="<?php echo e(__tr('Active')); ?>"
                        href="<?= route('vendor.contact.group.read.list_view', ['status' => 'active']) ?>">
                        <?= __tr('Active') ?>
                    </a>
                </li>
                <!-- /Active tab -->

                <!-- Archive tab -->
                <li class="nav-item">
                    <a class="nav-link  <?= $status == 'archived' ? 'active' : '' ?>  "
                        data-title="<?php echo e(__tr('Archive')); ?>"
                        href="<?= route('vendor.contact.group.read.list_view', ['status' => 'archived']) ?>">
                        <?= __tr('Archive') ?>
                    </a>
                </li>
                <!-- /Archive tab -->
            </ul>
            <!-- Add New Group Modal -->
            <?php if (isset($component)) { $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.modal','data' => ['id' => 'lwAddNewGroup','header' => __tr('Add New Group'),'hasForm' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwAddNewGroup','header' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Add New Group')),'hasForm' => true]); ?>
                <!--  Add New Group Form -->
                <?php if (isset($component)) { $__componentOriginald0b55ee435ec3aeeadffee8b0df479da = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.form','data' => ['id' => 'lwAddNewGroupForm','action' => route('vendor.contact.group.write.create'),'dataCallbackParams' => ['modalId' => '#lwAddNewGroup', 'datatableId' => '#lwGroupList'],'dataCallback' => 'appFuncs.modelSuccessCallback']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwAddNewGroupForm','action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('vendor.contact.group.write.create')),'data-callback-params' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['modalId' => '#lwAddNewGroup', 'datatableId' => '#lwGroupList']),'data-callback' => 'appFuncs.modelSuccessCallback']); ?>
                    <!-- form body -->
                    <div class="lw-form-modal-body">
                        <!-- form fields form fields -->
                        <!-- Title -->
                        <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'text','id' => 'lwTitleField','dataFormGroupClass' => '','label' => __tr('Title'),'name' => 'title','required' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'text','id' => 'lwTitleField','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Title')),'name' => 'title','required' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                        <!-- /Title -->
                        <!-- Description -->
                        <div class="form-group">
                            <label for="lwDescriptionField"><?php echo e(__tr('Description')); ?></label>
                            <textarea cols="10" rows="3" id="lwDescriptionField" class="lw-form-field form-control"
                                placeholder="<?php echo e(__tr('Description')); ?>" name="description"></textarea>
                        </div>
                        <!-- /Description -->
                    </div>
                    <!-- form footer -->
                    <div class="modal-footer">
                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-primary"><?php echo e(__tr('Submit')); ?></button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__tr('Close')); ?></button>
                    </div>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $attributes = $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $component = $__componentOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
                <!--/  Add New Group Form -->
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $attributes = $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $component = $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
            <!--/ Add New Group Modal -->

            <!-- Edit Group Modal -->
            <?php if (isset($component)) { $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.modal','data' => ['id' => 'lwEditGroup','header' => __tr('Edit Group'),'hasForm' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwEditGroup','header' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Edit Group')),'hasForm' => true]); ?>
                <!--  Edit Group Form -->
                <?php if (isset($component)) { $__componentOriginald0b55ee435ec3aeeadffee8b0df479da = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.form','data' => ['id' => 'lwEditGroupForm','action' => route('vendor.contact.group.write.update'),'dataCallbackParams' => ['modalId' => '#lwEditGroup', 'datatableId' => '#lwGroupList'],'dataCallback' => 'appFuncs.modelSuccessCallback']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwEditGroupForm','action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('vendor.contact.group.write.update')),'data-callback-params' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['modalId' => '#lwEditGroup', 'datatableId' => '#lwGroupList']),'data-callback' => 'appFuncs.modelSuccessCallback']); ?>
                    <!-- form body -->
                    <div id="lwEditGroupBody" class="lw-form-modal-body"></div>
                    <script type="text/template" id="lwEditGroupBody-template">

                        <input type="hidden" name="contactGroupIdOrUid" value="<%- __tData._uid %>" />
                        <!-- form fields -->
                        <!-- Title -->
           <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'text','id' => 'lwTitleEditField','dataFormGroupClass' => '','label' => __tr('Title'),'value' => '<%- __tData.title %>','name' => 'title','required' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'text','id' => 'lwTitleEditField','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Title')),'value' => '<%- __tData.title %>','name' => 'title','required' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                <!-- /Title -->
                <!-- Description -->
                <div class="form-group">
                <label for="lwDescriptionEditField"><?php echo e(__tr('Description')); ?></label>
                <textarea cols="10" rows="3" id="lwDescriptionEditField" value="<%- __tData.description %>" class="lw-form-field form-control" placeholder="<?php echo e(__tr('Description')); ?>" name="description" ><%- __tData.description %></textarea>
            </div>
                <!-- /Description -->
                     </script>
                    <!-- form footer -->
                    <div class="modal-footer">
                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-primary"><?php echo e(__tr('Submit')); ?></button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__tr('Close')); ?></button>
                    </div>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $attributes = $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $component = $__componentOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
                <!--/  Edit Group Form -->
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $attributes = $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $component = $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
            <!--/ Edit Group Modal -->
            
                <!--datatable -->
                <?php if (isset($component)) { $__componentOriginal49c2f9c26fb91807a4f87ab8f845e982 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.datatable','data' => ['dataPageLength' => '50','id' => 'lwGroupList','url' => route('vendor.contact.group.read.list', ['status' => $status])]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.datatable'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data-page-length' => '50','id' => 'lwGroupList','url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('vendor.contact.group.read.list', ['status' => $status]))]); ?>
                    <div class="">
                        <button x-show="!isSelectedAll" class="btn btn-dark btn-sm mb-2" @click="toggleAll"><?php echo e(__tr('Select All')); ?></button>
                        <button x-show="isSelectedAll" class="btn btn-dark btn-sm mb-2" @click="toggleAll"><?php echo e(__tr('Unselect All')); ?></button>
                        <div class="btn-group mb-2">
                            <!-- bulk action btn -->
                            <button :class="!selectedContacts.length ? 'disabled' : ''"
                                class="btn btn-danger mt-1 btn-sm dropdown-toggle" type="button" data-toggle="dropdown"
                                aria-expanded="false">
                                <?php echo e(__tr('Bulk Actions')); ?>

                            </button>
                            <!-- /bulk action btn -->
                            <div class="dropdown-menu">
                                <!-- delete action btn -->
                                <a class="dropdown-item" @click.prevent="deleteSelectedContactGroups" href="#"><?php echo e(__tr('Delete Selected Groups')); ?></a>
                                <!-- /delete action btn -->
                                <?php if($status == 'active'): ?>
                                <!-- archive action btn -->
                                <a class="dropdown-item" @click.prevent="archiveSelectedContactGroups" href="#"><?php echo e(__tr('Archive Selected Groups')); ?></a>
                                <!-- /archive action btn -->
                                <?php else: ?>
                                <!-- unarchive action btn -->
                                <a class="dropdown-item" @click.prevent="unarchiveSelectedContactGroups" href="#"><?php echo e(__tr('Unarchive Selected Groups')); ?></a>
                                <!-- /unarchive action btn -->
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <th style="width: 1px;padding:0;" data-name="none"></th>
                    <th  data-name="none" data-template="#lwSelectMultipleContactGroupsCheckbox"><?php echo e(__tr('Select')); ?>

                    </th>
                    <th data-orderable="true" data-name="title"><?php echo e(__tr('Title')); ?></th>
                    <th data-name="description"><?php echo e(__tr('Description')); ?></th>
                    <th data-template="#groupActionColumnTemplate" name="null"><?php echo e(__tr('Action')); ?></th>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982)): ?>
<?php $attributes = $__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982; ?>
<?php unset($__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal49c2f9c26fb91807a4f87ab8f845e982)): ?>
<?php $component = $__componentOriginal49c2f9c26fb91807a4f87ab8f845e982; ?>
<?php unset($__componentOriginal49c2f9c26fb91807a4f87ab8f845e982); ?>
<?php endif; ?>


            
            <!--datatable -->
        </div>

        <!-- action template -->
        <script type="text/template" id="groupActionColumnTemplate">
            <a title="<?php echo e(__tr('Group Contacts')); ?>" class="lw-btn btn btn-sm btn-warning" href="<%= __Utils.apiURL("<?php echo e(route('vendor.contact.read.list_view', [ 'groupUid'])); ?>", {'groupUid': __tData._uid}) %>"><i class="fa fa-users"></i> <?php echo e(__tr('Group Contacts')); ?></a>
            <a data-pre-callback="appFuncs.clearContainer" title="<?php echo e(__tr('Edit')); ?>" class="lw-btn btn btn-sm btn-default lw-ajax-link-action" data-response-template="#lwEditGroupBody" href="<%= __Utils.apiURL("<?php echo e(route('vendor.contact.group.read.update.data', [ 'contactGroupIdOrUid'])); ?>", {'contactGroupIdOrUid': __tData._uid}) %>"  data-toggle="modal" data-target="#lwEditGroup"><i class="fa fa-edit"></i> <?php echo e(__tr('Edit')); ?></a>
            <!--  Delete Action -->
            <a data-method="post" href="<%= __Utils.apiURL("<?php echo e(route('vendor.contact.group.write.delete', [ 'contactGroupIdOrUid'])); ?>", {'contactGroupIdOrUid': __tData._uid}) %>" class="btn btn-danger btn-sm lw-ajax-link-action-via-confirm" data-confirm="#lwDeleteGroup-template" title="<?php echo e(__tr('Delete')); ?>" data-callback-params="<?php echo e(json_encode(['datatableId' => '#lwGroupList'])); ?>" data-callback="appFuncs.modelSuccessCallback"><i class="fa fa-trash"></i> <?php echo e(__tr('Delete')); ?></a>
              <!--  Delete Action -->
                <!--  Archive Action -->
            <% if(__tData.status != 5) { %>
                <a data-method="post" href="<%= __Utils.apiURL("<?php echo e(route('vendor.contact.group.write.archive', [ 'contactGroupIdOrUid'])); ?>", {'contactGroupIdOrUid': __tData._uid}) %>" class="btn btn-light btn-sm lw-ajax-link-action-via-confirm" data-confirm="#lwArchiveGroup-template" title="<?php echo e(__tr('Archive')); ?>" data-callback-params="<?php echo e(json_encode(['datatableId' => '#lwGroupList'])); ?>" data-callback="appFuncs.modelSuccessCallback"><?php echo e(__tr('Archive')); ?></a>
                <% } else { %>
                    <a data-method="post" href="<%= __Utils.apiURL("<?php echo e(route('vendor.contact.group.write.unarchive', [ 'contactGroupIdOrUid'])); ?>", {'contactGroupIdOrUid': __tData._uid}) %>" class="btn btn-light btn-sm lw-ajax-link-action-via-confirm" data-confirm="#lwUnarchiveGroup-template" title="<?php echo e(__tr('Unarchive')); ?>" data-callback-params="<?php echo e(json_encode(['datatableId' => '#lwGroupList'])); ?>" data-callback="appFuncs.modelSuccessCallback"><?php echo e(__tr('Unarchive')); ?></a>

                <% } %>
                  <!--  Archive Action -->
    </script>
        <!-- /action template -->
        <!-- select multiple -->
        <script type="text/template" id="lwSelectMultipleContactGroupsCheckbox">
            <input @click="toggle('<%- __tData._uid %>')" type="checkbox" name="selected_groups[]" class="lw-checkboxes custom-checkbox" value="<%- __tData._uid %>">
        </script>
        <!-- /select multiple -->

        <!-- Group delete template -->
        <script type="text/template" id="lwDeleteGroup-template">
            <h2><?php echo e(__tr('Are You Sure!')); ?></h2>
            <p><?php echo e(__tr('You want to delete this Group?')); ?></p>
    </script>
        <!-- /Group delete template -->
        <!-- Group archive template -->
        <script type="text/template" id="lwArchiveGroup-template">
            <h2><?php echo e(__tr('Are You Sure!')); ?></h2>
            <p><?php echo e(__tr('You want to archive this Group?')); ?></p>
    </script>
        <!-- /Group archive template -->
        <!-- Group unarchive template -->
        <script type="text/template" id="lwUnarchiveGroup-template">
            <h2><?php echo e(__tr('Are You Sure!')); ?></h2>
            <p><?php echo e(__tr('You want to unarchive this Group?')); ?></p>
    </script>
        <!-- /Group archive template -->
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['title' => __tr('Contact Groups')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/workwatsup-new.jmd-infotech.in/resources/views/contact/contact-group/group-list.blade.php ENDPATH**/ ?>