<?php
$onlyTemplatePreview = request()->has('only-preview');
?>
<div class="row" x-cloak>
    <?php if(!$onlyTemplatePreview): ?>
    <div class="col-sm-12 col-md-8 col-lg-6 lw-template-structure-form">
        <input type="hidden" name="template_uid" value="<?php echo e($template->_uid); ?>">
        <fieldset>
            <legend><?php echo e(__tr('Template')); ?> <template x-if="selectedTemplate">
                    <button class="btn btn-dark btn-sm lw-change-template-btn" @click.prevent="selectedTemplate = ''"><?php echo e(__tr('Change')); ?></button>
                </template></legend>
            <h3><strong><?php echo e($template->template_name); ?></strong></h3>
            <h4><?php echo e(__tr('Language Code')); ?>: <strong><?php echo e($template->language); ?></strong></h4>
            <h4><?php echo e(__tr('Category')); ?>: <strong><?php echo e($template->category); ?></strong></h4>
        </fieldset>
        
        <?php if($headerFormat): ?>
        <fieldset class="lw-template-header-variables-container">
            <legend><?php echo e(__tr('Header')); ?></legend>
            <?php if($headerFormat == 'LOCATION'): ?>
            <h3><?php echo e(__tr('Location Details')); ?></h3>
            <?php echo $__env->make('whatsapp-service.template-partial', [
            'parameters' => [
            'location_latitude',
            'location_longitude',
            'location_name',
            'location_address',
            ],
            'subjectType' => 'header',
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php elseif($headerFormat == 'TEXT' and !__isEmpty($headerParameters)): ?>
            <?php echo $__env->make('whatsapp-service.template-partial', [
            'parameters' => $headerParameters,
            'subjectType' => 'header',
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php elseif($headerFormat == 'TEXT' and __isEmpty($headerParameters)): ?>
            <div class="alert alert-info"><?php echo e(__tr('No variables available for header text.')); ?></div>
            <style>
                .lw-template-header-variables-container{display:none;}
            </style>
            <?php elseif($headerFormat == 'IMAGE'): ?>
            <div class="form-group col-md-4 col-sm-12">
                <label for="lwHeaderImageFilepond"><?php echo e(__tr('Select Image')); ?></label>
                <input id="lwHeaderImageFilepond" type="file" data-allow-revert="true"
                    data-label-idle="<?php echo e(__tr('Select Image')); ?>" class="lw-file-uploader" data-instant-upload="true"
                    data-action="<?= route('media.upload_temp_media', 'whatsapp_image') ?>" data-allowed-media='<?php echo e(getMediaRestriction('whatsapp_image')); ?>'
                    data-file-input-element="#lwHeaderImage"<?= ($pageType == 'bot_reply_form') ? "data-lw-plugin=\"lwUploader\"" : ''; ?>>
                <input id="lwHeaderImage" type="hidden" value="" name="header_image" />
            </div>
            <?php elseif($headerFormat == 'VIDEO'): ?>
            <div class="form-group col-md-4 col-sm-12">
                <label for="lwHeaderVideoFilepond"><?php echo e(__tr('Select Video')); ?></label>
                <input id="lwHeaderVideoFilepond" type="file" data-allow-revert="true"
                    data-label-idle="<?php echo e(__tr('Select Video')); ?>" class="lw-file-uploader" data-instant-upload="true"
                    data-action="<?= route('media.upload_temp_media', 'whatsapp_video') ?>" data-allowed-media='<?php echo e(getMediaRestriction('whatsapp_video')); ?>'
                    data-file-input-element="#lwHeaderVideo"<?= ($pageType == 'bot_reply_form') ? "data-lw-plugin=\"lwUploader\"" : ''; ?>>
                <input id="lwHeaderVideo" type="hidden" value="" name="header_video" />
            </div>
            <?php elseif($headerFormat == 'DOCUMENT'): ?>
            <div class="form-group col-md-4 col-sm-12">
                <label for="lwHeaderDocumentFilepond"><?php echo e(__tr('Select Document')); ?></label>
                <input id="lwHeaderDocumentFilepond" type="file" data-allow-revert="true"
                    data-label-idle="<?php echo e(__tr('Select Document')); ?>" class="lw-file-uploader" data-instant-upload="true"
                    data-action="<?= route('media.upload_temp_media', 'whatsapp_document') ?>" data-allowed-media='<?php echo e(getMediaRestriction('whatsapp_document')); ?>'
                    data-file-input-element="#lwHeaderDocument">
                <input id="lwHeaderDocument" type="hidden" value="" name="header_document" />
            </div>
            <?php echo $__env->make('whatsapp-service.template-partial', [
            'parameters' => [
            'header_document_name'
            ],
            'subjectType' => 'header',
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endif; ?>
        </fieldset>
        <?php endif; ?>
        
        
        <?php if(!__isEmpty($bodyParameters)): ?>
        <fieldset>
            <legend><?php echo e(__tr('Body')); ?></legend>
            <?php echo $__env->make('whatsapp-service.template-partial', [
            'parameters' => $bodyParameters,
            'subjectType' => 'body',
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </fieldset>
        <?php endif; ?>
        
        
        <?php if(!__isEmpty($buttonParameters) or !__isEmpty($buttonItems)): ?>
        <fieldset>
            <legend><?php echo e(__tr('Buttons')); ?></legend>
            <?php echo $__env->make('whatsapp-service.template-partial', [
            'parameters' => $buttonParameters,
            'buttonItems' => $buttonItems,
            'subjectType' => 'button',
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php if(array_key_exists('COPY_CODE', $buttonItems)): ?>
            <label for=""><?php echo e(__tr('Code for Copy')); ?></label>
            <?php echo $__env->make('whatsapp-service.template-partial', [
            'parameters' => [
            'copy_code'
            ],
            'buttonItems' => [],
            'subjectType' => 'button',
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endif; ?>
        </fieldset>
        <?php endif; ?>
        

        <?php if(!__isEmpty($carouselTemplateData)): ?>
            <fieldset>
                <legend><?php echo e(__tr('Cards')); ?></legend>
                <?php $__currentLoopData = $carouselTemplateData[1]['cards']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cardIndex => $cardItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <fieldset>
                        <legend><?php echo e($cardIndex + 1); ?></legend>
                        <?php if($cardItem['components'][0]['type'] == 'HEADER'): ?>
                            <h3><u><?php echo e(__tr('Media Header')); ?></u></h3>
                            <input id="lwUploadMediaType" type="hidden" value="<?php echo e($cardItem['components'][0]['format']); ?>" name="carousel_templates[<?php echo e($cardIndex); ?>][uploaded_media_file_type]" />
                            
                            <?php if($cardItem['components'][0]['format'] == 'IMAGE'): ?>
                                <div class="form-group col-md-4 col-sm-12">
                                    <label for="lwHeaderImage<?php echo e($cardIndex); ?>"><?php echo e(__tr('Select Image')); ?></label>
                                    <input id="lwHeaderImage<?php echo e($cardIndex); ?>" type="file" data-allow-revert="true"
                                        data-label-idle="<?php echo e(__tr('Select Image')); ?>" class="lw-file-uploader" data-instant-upload="true"
                                        data-action="<?= route('media.upload_temp_media', 'whatsapp_image') ?>" data-allowed-media='<?php echo e(getMediaRestriction('whatsapp_image')); ?>'
                                        data-file-input-element="#lwHeaderUpload<?php echo e($cardIndex); ?>"<?= ($pageType == 'bot_reply_form') ? "data-lw-plugin=\"lwUploader\"" : ''; ?>>
                                    <input id="lwHeaderUpload<?php echo e($cardIndex); ?>" type="hidden" value="" name="carousel_templates[<?php echo e($cardIndex); ?>][uploaded_media_file_name]" required="true"/>
                                </div>
                            <?php endif; ?>

                            <?php if($cardItem['components'][0]['format'] == 'VIDEO'): ?>
                                <div class="form-group col-md-4 col-sm-12">
                                    <label for="lwHeaderImage<?php echo e($cardIndex); ?>"><?php echo e(__tr('Select Video')); ?></label>
                                    <input id="lwHeaderImage<?php echo e($cardIndex); ?>" type="file" data-allow-revert="true"
                                        data-label-idle="<?php echo e(__tr('Select Video')); ?>" class="lw-file-uploader" data-instant-upload="true"
                                        data-action="<?= route('media.upload_temp_media', 'whatsapp_video') ?>" data-allowed-media='<?php echo e(getMediaRestriction('whatsapp_video')); ?>'
                                        data-file-input-element="#lwHeaderUpload<?php echo e($cardIndex); ?>" <?= ($pageType == 'bot_reply_form') ? "data-lw-plugin=\"lwUploader\"" : ''; ?>>
                                    <input id="lwHeaderUpload<?php echo e($cardIndex); ?>" type="hidden" value="" name="carousel_templates[<?php echo e($cardIndex); ?>][uploaded_media_file_name]" required="true"/>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                                    
                        <?php if($cardItem['components'][1]['type'] == 'BODY'): ?>
                            <?php if(isset($cardItem['components'][1]['example'])): ?>
                                <h3><u><?php echo e(__tr('Body Text')); ?></u></h3>
                                <?php 
                                    $carouselBodyData = [];
                                    foreach ($cardItem['components'][1]['example']['body_text'][0] as $bodyTextIndex => $bodyTextExample) {
                                        $carouselBodyData[] = [
                                            'id' => 'lwField_'. $cardIndex. '_' .$bodyTextIndex, 
                                            'label' => 'field_' . $bodyTextIndex + 1,
                                            'name' => "carousel_templates[$cardIndex][body_example_fields][$bodyTextIndex]"
                                        ];
                                    }
                                ?>
                                
                                <?php echo $__env->make('whatsapp-service.template-partial', [
                                    'parameters' => $carouselBodyData,
                                    'subjectType' => 'body',
                                ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php endif; ?>
                        <?php endif; ?>

                        <?php if($cardItem['components'][2]['type'] == 'BUTTONS'): ?>
                            <h3><u><?php echo e(__tr('Buttons')); ?></u></h3>
                            <?php $__currentLoopData = $cardItem['components'][2]['buttons']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $buttonIndex => $button): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <input type="hidden" value="<?php echo e($button['type']); ?>" name="carousel_templates[<?php echo e($cardIndex); ?>][button_type][<?php echo e($buttonIndex); ?>]">
                                <?php if($button['type'] == 'QUICK_REPLY'): ?>
                                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['id' => 'lwQuickReplyPayload','type' => 'text','dataFormGroupClass' => '','label' => __tr('Quick Reply Button Payload'),'name' => 'carousel_templates['.e($cardIndex).'][quick_reply_button_payload]']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwQuickReplyPayload','type' => 'text','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Quick Reply Button Payload')),'name' => 'carousel_templates['.e($cardIndex).'][quick_reply_button_payload]']); ?>
                                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                                <?php endif; ?>

                                <?php if(isset($button['example'])): ?>
                                    <?php echo $__env->make('whatsapp-service.template-partial', [
                                        'parameters' => [
                                            [
                                                'id' => 'lwField_'. $cardIndex. '_' .$buttonIndex, 
                                                'label' => 'field_' . $buttonIndex,
                                                'name' => "carousel_templates[$cardIndex][button_example_field]"
                                            ]
                                        ],
                                        'subjectType' => 'body',
                                    ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </fieldset>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </fieldset>
        <?php endif; ?>

    </div>
    
    <div class="col-sm-12 col-md-8 col-lg-6">
        <fieldset class="w-100 lw-position-block">
            <legend><?php echo e(__tr('Message Preview')); ?></legend>
            <div class="card">
                <div class="card-body">
                    <?php else: ?>
                    <div class="col-12">
                    <?php endif; ?>
                    <?php echo $__env->make('whatsapp-service.template-preview-partial', [
            'bodyComponentText' => $bodyComponentText,
            'parameters' => $bodyParameters,
            'subjectType' => 'body',
            'templateComponents' => $templateComponents
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
 </div>
<?php if(!$onlyTemplatePreview): ?>
            </div>
            <div class="alert alert-light mt-5">
                <strong><?php echo e(__tr('Please note:')); ?></strong>
               <?php echo __tr('Words like {{1}}, {{abc}} etc are dynamic variables and will be replaced based on your selections.'); ?>

            </div>
            <?php endif; ?>
        </fieldset>
    </div>
</div><?php /**PATH /home/imqsvuod/wala.guru/wbiz/resources/views/whatsapp-service/message-preparation.blade.php ENDPATH**/ ?>