<?php
$vendorIdOrUid = $vendorIdOrUid ?? getVendorUid();
if(!isset($vendorViewBySuperAdmin)) {
$vendorViewBySuperAdmin = null;
}
?>
<?php $__env->startSection('content'); ?>
<?php if(hasCentralAccess()): ?>
<?php echo $__env->make('users.partials.header', [
'title' => __tr('__vendorTitle__ Dashboard', [
'__vendorTitle__' => $vendorInfo['title'] ?? getVendorSettings('title')
]),
'description' => '',
// 'class' => 'col-lg-7'
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<!--<?php else: ?>-->

<?php endif; ?>
<div class="container-fluid">
    <?php if(hasCentralAccess()): ?>
    <?php
    $currentActivePlanDetails = getVendorCurrentActiveSubscription($vendorInfo['id']);
    $planDetails = vendorPlanDetails(null, null, $vendorInfo['id']);
    ?>
    <div class="col-xl-12 p-0">
        <!-- breadcrumbs -->
        <nav aria-label="breadcrumb" class="lw-breadcrumb-container">
            <ol class="breadcrumb bg-transparent text-light p-0 m-0">
                <li class=" breadcrumb-item mb-3">
                    <a class="text-decoration-none" href="<?php echo e(route('central.vendors')); ?>"><?php echo e(__tr('Manage Vendors')); ?></a>

                </li>
                <li class="text-light breadcrumb-item" aria-current="page"><?php echo e(__tr('Dashboard')); ?></li>
            </ol>
        </nav>
        <!-- /breadcrumbs -->
    </div>
    <br>
    <?php endif; ?>
    <?php echo $__env->make('layouts.headers.cards', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php if(hasVendorAccess() or $vendorViewBySuperAdmin ): ?>
<div class="container-fluid">
    <?php if(getVendorSettings('whatsapp_access_token_expired', null, null, $vendorIdOrUid)): ?>
    <div class="alert alert-danger">
        <?php echo e(__tr('Your WhatsApp token seems to be expired, Generate new token, prefer creating permanent token and save.')); ?>

        <br>
        <a class="btn btn-sm btn-white my-2"
            href="<?php echo e(route('vendor.settings.read', ['pageType' => 'whatsapp-cloud-api-setup'])); ?>"><?php echo e(__tr('Cloud API setup')); ?></a>
    </div>
    <?php elseif(!isWhatsAppBusinessAccountReady($vendorIdOrUid)): ?>
    <div class="alert alert-danger">
        <?php echo e(__tr('You are not ready to send messages, WhatsApp Setup is Incomplete')); ?>

        <br>
        <a class="btn btn-sm btn-white my-2"
            href="<?php echo e(route('vendor.settings.read', ['pageType' => 'whatsapp-cloud-api-setup'])); ?>"><?php echo e(__tr('Complete your WhatsApp Cloud API setup')); ?></a>
    </div>
    <?php endif; ?>
    <?php if(getAppSettings('pusher_by_vendor') and !getVendorSettings('pusher_app_id', null, null, $vendorIdOrUid)): ?>
    <div class="alert alert-warning">
        <?php echo e(__tr('Pusher keys needs to setup for realtime communication like Chat etc., You can get it from __pusherLink__, choose channel and create the app to get the required keys.', [
        '__pusherLink__' => '<a target="blank" href="https://pusher.com">pusher.com</a>'
        ])); ?>

        <br>
        <a class="btn btn-sm btn-white my-2"
            href="<?php echo e(route('vendor.settings.read', ['pageType' => 'general'])); ?>#pusherKeysConfiguration"><?php echo e(__tr('Pusher Configuration')); ?></a>
    </div>
    <?php endif; ?>
    <?php if(!$vendorViewBySuperAdmin): ?>
    <div class="row">
        <div class="col-12 mb-5">
            <fieldset>
                <legend><?php echo e(__tr('Quick Start')); ?></legend>
                <h3>
                    <ol>
                        <li><?php echo e(__tr('Login to your Facebook Account')); ?></li>
                        <li><?php echo __tr('Complete Setup as Shown in __cloudApiSetupLink__', [
                            '__cloudApiSetupLink__' => '<a
                                href="'. route('vendor.settings.read', ['pageType' => 'whatsapp-cloud-api-setup']) .'">'.
                                __tr('WhatsApp Cloud API Setup').'</a>'
                            ]); ?></li>
                        <li><?php echo __tr('Manage and Sync WhatsApp templates at __manageContactsLink__',[
                            '__manageContactsLink__' => '<a href="'. route('vendor.whatsapp_service.templates.read.list_view') .'">'. __tr('Manage WhatsApp Templates').'</a>'
                            ]); ?></li>
                        <li><?php echo __tr('Create your contact groups using __manageGroupsLink__', [
                            '__manageGroupsLink__' => '<a href="'. route('vendor.contact.group.read.list_view') .'">'.
                                __tr('Manage Groups').'</a>'
                            ]); ?></li>
                        <li><?php echo __tr('Create your Contacts or Upload excel file with predefined exportable template at __manageContactsLink__',[
                            '__manageContactsLink__' => '<a href="'. route('vendor.contact.read.list_view') .'">'.
                                __tr('Manage Contacts').'</a>'
                            ]); ?></li>
                        <li><?php echo __tr('Create & Schedule your Campaigns at __manageCampaignsLink__',[
                            '__manageCampaignsLink__' => '<a href="'. route('vendor.campaign.read.list_view') .'">'.
                                __tr('Manage Campaigns').'</a>'
                            ]); ?></li>
                    </ol>
                </h3>
            </fieldset>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php endif; ?>

<?php if(hasCentralAccess()): ?>
    <div class="col-xl-12 pl-1">
        <div class="">
            <div class="card-body">
                <fieldset class="mb-5">
                    <legend><?php echo e(__tr('Vendor Details')); ?></legend>
                     <div class="col-xl-12 ">
                        <a data-method="post" class="btn btn-light btn-sm lw-ajax-link-action float-right" href="<?php echo e(route('central.vendors.user.write.login_as',['vendorUid'=>$vendorIdOrUid])); ?>"   data-confirm="#lwLoginAs-template" title="<?php echo e(__tr('Login as Vendor Admin')); ?>"><i class="fa fa-sign-in-alt"></i> <?php echo e(__tr('Login')); ?></a>
                    </div>
                    <div class="my-2 ">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Vendor Title:')); ?></h4>
                        <p class="card-text"><?php echo e($vendorInfo['title']); ?> </p>
                    </div>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Account Status:')); ?></h4>
                        <?php if($vendorInfo['status']==0): ?>
                        <p class="card-text"><?php echo e(__tr('Inactive')); ?></p>
                        <?php else: ?>
                        <p class="card-text"><?php echo e(configItem('status_codes',$vendorInfo['status'])); ?></p>
                        <?php endif; ?>

                    </div>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Created On:')); ?></h4>
                        <p class="card-text"><?php echo e(formatDate($vendorUserData['created_at'])); ?></p>
                    </div>
                    <hr>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Admin User Name:')); ?></h4>
                        <p class="card-text"><?php echo e(maskForDemo($vendorUserData['first_name'] . ' ' . $vendorUserData['last_name'])); ?></p>
                    </div>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Username:')); ?></h4>
                        <p class="card-text"><?php echo e(maskForDemo($vendorUserData['username'])); ?></p>
                    </div>
                    <?php if($vendorUserData['mobile_number']): ?>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Phone Number:')); ?></h4>
                        <p class="card-text"><?php echo e(maskForDemo($vendorUserData['mobile_number'])); ?></p>
                    </div>
                    <?php endif; ?>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Email:')); ?></h4>
                        <p class="card-text"><?php echo e(maskForDemo($vendorUserData['email'])); ?></p>
                    </div>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Admin User Status:')); ?></h4>
                        <?php if($vendorUserData['status']==0): ?>
                        <p class="card-text"><?php echo e(__tr('Inactive')); ?></p>
                        <?php else: ?>
                        <p class="card-text"><?php echo e(configItem('status_codes', $vendorUserData['status'])); ?></p>
                        <?php endif; ?>
                    </div>
                </fieldset>

                <fieldset class="mb-4">
                    <?php
                    $planStructure = $planDetails->plan_id ? getPaidPlans($planDetails->plan_id) : getFreePlan();
                    $planCharges = $planStructure['charges'][$planDetails->frequency] ?? null;
                    ?>
                    <legend><?php echo e(__tr('Current Subscribed Plan')); ?></legend>
                    <div class="col-xl-12  text-right">
                        <a class="btn btn-primary btn-sm " href="<?php echo e(route('central.vendor.details',['vendorIdOrUid'=>$vendorIdOrUid])); ?>" title="<?php echo e(__tr('Subscription')); ?>"> <?php echo e(__tr('Subscription')); ?></a>
                    </div>
                    <?php if($planDetails->hasActivePlan()): ?>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Plan Title:')); ?></h4>
                        <p class="card-text"><?php echo e($planDetails->planTitle()); ?> </p>
                    </div>
                    <?php if($planCharges): ?>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Current Plan Charges:')); ?></h4>
                        <p class="card-text"> <?php echo e($planCharges['title'] ?? ''); ?> <?php echo e(formatAmount($planCharges['charge'],
                            true)); ?></p>
                    </div>
                    <?php endif; ?>
                    <?php if($currentActivePlanDetails): ?>
                    <?php if($planDetails['subscription_type']=='manual'): ?>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Status:')); ?></h4>
                        <p class="card-text"><?php echo e(configItem('subscription_status',$currentActivePlanDetails['status'])); ?></p>
                    </div>
                    <?php elseif($planDetails['subscription_type']=='auto'): ?>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Status:')); ?></h4>
                        <p class="card-text"><?php echo e(configItem('subscription_status',$currentActivePlanDetails['stripe_status'])); ?></p>
                    </div>
                    <?php else: ?>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Status:')); ?></h4>
                        <p class="card-text"><?php echo e(__tr('Active')); ?></p>
                    </div>
                    <?php endif; ?>
                    <?php endif; ?>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Subscription Type:')); ?></h4>
                        <p class="card-text"><?php echo e(configItem('subscription_methods',$planDetails['subscription_type'])); ?></p>
                    </div>
                    <?php if($currentActivePlanDetails): ?>
                     
                    <?php if($planDetails['subscription_type']=='manual'): ?>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Payment Method:')); ?></h4>
                        <p class="card-text"><?php echo e($currentActivePlanDetails['__data']['manual_txn_details']['selected_payment_method'] ?? 'NA'); ?></p>
                    </div>
                    <?php endif; ?>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Created On:')); ?></h4>
                        <p class="card-text"><?php echo e(formatDate($currentActivePlanDetails['created_at'])); ?></p>
                    </div>
                    <?php endif; ?>
                    <div class="my-2">
                        <h4 class="text-dark font-weight-bold"><?php echo e(__tr('Expire On:')); ?></h4>
                        <p class="card-text"><?php echo e($planDetails['ends_at'] ? formatDate($planDetails['ends_at']):  'NA'); ?></p>
                    </div>
                    <?php else: ?>
                    <div class="alert alert-warning"><?php echo e(__tr('Vendor does not have any active plan.')); ?></div>
                    <?php endif; ?>

                </fieldset>

            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<script type="text/template" id="lwLoginAs-template">
    <h2><?php echo e(__tr('Are You Sure!')); ?></h2>
    <p><?php echo e(__tr('You want login to this vendor admin account?')); ?></p>
</script>
<?php if(isThisDemoVendorAccountAccess()): ?>
<div class="container-fluid">
    <div class="row">
        <div class="col">
            <div class="alert alert-dark">
                <h2 class="text-white"><?php echo e(__tr('Demo Account')); ?></h2>
                <p><?php echo e(__tr('Contacts created here with your numbers will be deleted frequently. You need to add your number to allow for test')); ?></p>
                <p><?php echo e(__tr('If you want to test system with your own account. Facebook also provides Test Number which
                    is very easy to setup and test. You can follow the steps given in Quick Start on dashboard to get
                    started.')); ?></p>
                     <a title="<?php echo e(__tr('You can update your numbers for test on this demo account')); ?>" class="lw-btn btn btn-xl btn-danger" href="#"  data-toggle="modal" data-target="#lwRegisterDemoNumber"><i class="fa fa-phone"></i> <?php echo e(__tr('Add Numbers for Test')); ?></a>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('vendors.demo-instructions', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php endif; ?>


<?php $__env->startPush('head'); ?>
<?= __yesset(['dist/css/dashboard.css'],true) ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('js'); ?>
<?= __yesset(['dist/js/dashboard.js'],true)?>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['title' => __tr('Dashboard')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/imqsvuod/wala.guru/wbiz/resources/views/vendors/vendor-dashboard.blade.php ENDPATH**/ ?>