<?php
/**
* Component : Contact
* Controller : ContactController
* File : contact.list.blade.php
* ----------------------------------------------------------------------------- */
$currentGroup = $groupUid ? $vendorContactGroups->where('_uid', $groupUid)->first() : null;
?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('users.partials.header', [
'title' => $groupUid ? __tr('__groupName__ group contacts', [
'__groupName__' => $currentGroup->title
]) : __tr('Contacts'),
// 'description' => $groupUid ? $currentGroup->description : '',
'class' => 'col-lg-7'
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php
$groupDescription = $groupUid ? $currentGroup->description : '';
?>
<div class="container-fluid mt-lg--6" x-data="initialContactsInfoData">
    <div class="row">
        <!-- button -->
        <div class="col-xl-12 mb-3">
            <div class="float-right">
                <?php if($groupUid): ?>
                <a class="lw-btn btn btn-secondary" href="<?php echo e(route('vendor.contact.group.read.list_view')); ?>"><?php echo e(__tr('Back to Contact Groups')); ?></a>
                <a class="lw-btn btn btn-secondary" href="<?php echo e(route('vendor.contact.read.list_view')); ?>"><?php echo e(__tr('Back to Contacts')); ?></a>
                <?php endif; ?>
                <button type="button" class="lw-btn btn btn-primary" data-toggle="modal" data-target="#lwAddNewContact">
                    <?php echo e(__tr('Create New Contact')); ?></button>
                <?php if(!$groupUid): ?>
                <button type="button" class="lw-btn btn btn-dark" data-toggle="modal" data-target="#lwExportDialog"> <i class="fa fa-download"></i> <?php echo e(__tr('Download Contacts')); ?></button>
                <button type="button" class="lw-btn btn btn-dark" data-toggle="modal"
                    data-target="#lwImportContactDialog"><i class="fa fa-upload"></i> <?php echo e(__tr('Upload Contacts')); ?></button>
                <?php endif; ?>
            </div>
        </div>
        <!--/ button -->
        
        <?php if (isset($component)) { $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.modal','data' => ['id' => 'lwImportContactDialog','header' => __tr('Upload Contacts'),'hasForm' => true,'dataPreCallback' => 'appFuncs.clearContainer']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwImportContactDialog','header' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Upload Contacts')),'hasForm' => true,'data-pre-callback' => 'appFuncs.clearContainer']); ?>
            <?php if (isset($component)) { $__componentOriginald0b55ee435ec3aeeadffee8b0df479da = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.form','data' => ['id' => 'lwImportContactDialogForm','action' => route('vendor.contact.write.import'),'dataCallbackParams' => ['modalId' => '#lwImportContactDialog', 'datatableId' => '#lwContactList'],'dataCallback' => 'window.onImportProcessUpdate']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwImportContactDialogForm','action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('vendor.contact.write.import')),'data-callback-params' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['modalId' => '#lwImportContactDialog', 'datatableId' => '#lwContactList']),'data-callback' => 'window.onImportProcessUpdate']); ?>
                <div class="lw-form-modal-body p-3">
                <div x-cloak class="text-center" x-show="existingImportRequestData.progress">
                    <h1 class="text-success" x-text="existingImportRequestData.progressCountFormatted"></h1>
                    <h4 x-show="existingImportRequestData.estimatedRemainingTime" class="text-muted"><?php echo e(__tr('Estimated time remaining')); ?></h4>
                    <h4 class="text-info" x-show="existingImportRequestData.estimatedRemainingTime" x-text="existingImportRequestData.estimatedRemainingTime"></h4>
                    <h3><?php echo e(__tr('Please wait ... contacts import is in progress')); ?></h3>
                    <div class="progress" role="progressbar" aria-label="<?php echo e(__tr('contacts import in progress')); ?>" :aria-valuenow="existingImportRequestData.progress" aria-valuemin="0" aria-valuemax="100">
                    <div class="progress-bar progress-bar-striped progress-bar-animated" :style="{'width':existingImportRequestData.progress + '%'}" style="width: 0%"></div>
                    </div>
                    <div>
                        <a class="lw-ajax-link-action btn btn-danger btn-sm" data-confirm="<?= __tr('Are you sure you want to abort importing contacts?') ?>" href="<?php echo e(route('vendor.contact.write.abort_import')); ?>" data-callback="__Utils.viewReload" role="button" data-method="post"><?php echo e(__tr('Abort')); ?></a>
                        <div>
                            <small class="text-muted"><?php echo e(__tr('In case process stuck at some point, please reload page.')); ?></small>
                        </div>
                    </div>
                </div>
                
                <div x-cloak x-show="!existingImportRequestData.progress" class="">
                    <div class="alert alert-danger">
                        <?php echo e(__tr('Please use Template from Download contacts dialog')); ?>

                    </div>
                    <p><?php echo e(__tr('You can import csv file with new contacts or existing updated.')); ?></p>
                    <div class="alert alert-light">
                        <h3><?php echo e(__tr('Conventions')); ?></h3>
                        <h4><?php echo e(__tr('Mobile Number')); ?></h4>
                        <?php echo e(__tr('Mobile number treated as unique entity, it should be with country code without prefixing
                        0 or +, if the Mobile number is found in the records other information for the same will get
                        updated with data from the csv file.')); ?>

                        <div class="mt-3">
                            <h4><?php echo e(__tr('Group')); ?></h4>
                            <?php echo e(__tr('Use comma separated group title, make sure groups are already exists into the
                            system. Groups won\'t be deleted, only new groups will be assigned.')); ?>

                        </div>
                    </div>
                    <div class="form-group ">
                        <input id="lwImportDocumentFilepond" type="file" data-allow-revert="true"
                            data-label-idle="<?php echo e(__tr('Select CSV File')); ?>" class="lw-file-uploader"
                            data-instant-upload="true"
                            data-action="<?= route('media.upload_temp_media', 'vendor_contact_import') ?>"
                            data-file-input-element="#lwImportDocument" data-allowed-media='<?php echo e(getMediaRestriction('
                            vendor_contact_import')); ?>'>
                        <input id="lwImportDocument" type="hidden" value="" name="document_name" />
                    </div>
                </div>
                </div>
                <!-- form footer -->
                <div x-cloak x-show="!existingImportRequestData.progress" class="modal-footer">
                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-primary"><?php echo e(__tr('Process Import')); ?></button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__tr('Close')); ?></button>
                    </div>
                </div>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $attributes = $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $component = $__componentOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $attributes = $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $component = $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
        
        
        <?php if (isset($component)) { $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.modal','data' => ['id' => 'lwExportDialog','header' => __tr('Download Contacts'),'hasForm' => true,'dataPreCallback' => 'appFuncs.clearContainer']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwExportDialog','header' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Download Contacts')),'hasForm' => true,'data-pre-callback' => 'appFuncs.clearContainer']); ?>
            <div class="lw-form-modal-body p-3">
                <h5><?php echo e(__tr('Export with Data')); ?></h5>
                <p><?php echo e(__tr('You can export all contacts csv file and import it back with updated data.')); ?></p>
                <a href="<?php echo e(route('vendor.contact.write.export', [
                    'exportType' => 'data',
                    'fileType' => 'csv',
                ])); ?>" data-method="post" class="btn btn-primary"><i class="fa fa-download"></i> <?php echo e(__tr('Download CSV File with Data')); ?></a>
                <hr>
                <h5><?php echo e(__tr('Blank CSV Template')); ?></h5>
                <p><?php echo e(__tr('You can download blank csv file and fill with data according to column header and import it
                    for updates.')); ?></p>
                <a href="<?php echo e(route('vendor.contact.write.export', [
                    'exportType' => 'blank',
                     'fileType' => 'csv',
                ])); ?>" data-method="post" class="btn btn-primary"> <i class="fa fa-download"></i> <?php echo e(__tr('Download CSV Blank Template')); ?></a>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__tr('Close')); ?></button>
            </div>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $attributes = $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $component = $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
        
        <!-- Add New Contact Modal -->
        <?php if (isset($component)) { $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.modal','data' => ['id' => 'lwAddNewContact','header' => __tr('Add New Contact'),'hasForm' => true,'dataPreCallback' => 'appFuncs.clearContainer']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwAddNewContact','header' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Add New Contact')),'hasForm' => true,'data-pre-callback' => 'appFuncs.clearContainer']); ?>
            <!--  Add New Contact Form -->
            <?php if (isset($component)) { $__componentOriginald0b55ee435ec3aeeadffee8b0df479da = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.form','data' => ['id' => 'lwAddNewContactForm','action' => route('vendor.contact.write.create'),'dataCallbackParams' => ['modalId' => '#lwAddNewContact', 'datatableId' => '#lwContactList'],'dataCallback' => 'appFuncs.modelSuccessCallback']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwAddNewContactForm','action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('vendor.contact.write.create')),'data-callback-params' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['modalId' => '#lwAddNewContact', 'datatableId' => '#lwContactList']),'data-callback' => 'appFuncs.modelSuccessCallback']); ?>
                <!-- form body -->
                <div class="lw-form-modal-body">
                    <!-- form fields form fields -->
                    <!-- First_Name -->
                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'text','id' => 'lwFirstNameField','dataFormGroupClass' => '','label' => __tr('First Name'),'name' => 'first_name']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'text','id' => 'lwFirstNameField','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('First Name')),'name' => 'first_name']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                    <!-- /First_Name -->
                    <!-- Last_Name -->
                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'text','id' => 'lwLastNameField','dataFormGroupClass' => '','label' => __tr('Last Name'),'name' => 'last_name']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'text','id' => 'lwLastNameField','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Last Name')),'name' => 'last_name']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                    <!-- /Last_Name -->
                    <!-- Country -->
                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'selectize','dataLwPlugin' => 'lwSelectize','id' => 'lwCountryField','dataFormGroupClass' => '','dataSelected' => ' ','label' => __tr('Country'),'name' => 'country']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'selectize','data-lw-plugin' => 'lwSelectize','id' => 'lwCountryField','data-form-group-class' => '','data-selected' => ' ','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Country')),'name' => 'country']); ?>
                         <?php $__env->slot('selectOptions', null, []); ?> 
                            <option value=""><?php echo e(__tr('Country')); ?></option>
                            <?php $__currentLoopData = getCountryPhoneCodes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $getCountryCode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($getCountryCode['_id']); ?>"><?php echo e($getCountryCode['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                         <?php $__env->endSlot(); ?>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                    <!-- /Country -->
                    <!-- Phone_Number -->
                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'number','id' => 'lwPhoneNumberField','dataFormGroupClass' => '','label' => __tr('Mobile Number'),'name' => 'phone_number','minlength' => '9','helpText' => __tr('Number should be with country code without 0 or +'),'required' => 'true','maxlength' => '20']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'number','id' => 'lwPhoneNumberField','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Mobile Number')),'name' => 'phone_number','minlength' => '9','helpText' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Number should be with country code without 0 or +')),'required' => 'true','maxlength' => '20']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                    <!-- /Phone_Number -->
                    <!-- Language Code -->
                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'text','id' => 'lwLanguageCodeField','dataFormGroupClass' => '','label' => __tr('Language Code'),'name' => 'language_code']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'text','id' => 'lwLanguageCodeField','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Language Code')),'name' => 'language_code']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                    <!-- /Language Code -->
                    <!-- Email -->
                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'email','id' => 'lwEmailField','dataFormGroupClass' => '','label' => __tr('Email'),'name' => 'email']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'email','id' => 'lwEmailField','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Email')),'name' => 'email']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                    <!-- /Email -->
                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'selectize','dataLwPlugin' => 'lwSelectize','id' => 'lwSelectGroupsField','dataFormGroupClass' => '','dataSelected' => ' ','label' => __tr('Groups'),'name' => 'contact_groups[]','multiple' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'selectize','data-lw-plugin' => 'lwSelectize','id' => 'lwSelectGroupsField','data-form-group-class' => '','data-selected' => ' ','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Groups')),'name' => 'contact_groups[]','multiple' => true]); ?>
                         <?php $__env->slot('selectOptions', null, []); ?> 
                            <option value=""><?php echo e(__tr('Select Groups')); ?></option>
                            <?php $__currentLoopData = $vendorContactGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendorContactGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($vendorContactGroup['_id']); ?>"><?php echo e($vendorContactGroup['title']); ?> <?php echo e($vendorContactGroup['status'] == 5  ? __tr('(Archived)') : ''); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                         <?php $__env->endSlot(); ?>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                    <div class="my-3">
                        <?php if (isset($component)) { $__componentOriginal85a79a3f590ffcc2d6473eb3120eb493 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.checkbox','data' => ['id' => 'lwPromotionalOpt','name' => 'whatsapp_opt_out','dataColor' => '#ff0000','dataSize' => 'small','value' => '1','dataLwPlugin' => 'lwSwitchery','label' => __tr('Opt out Marketing Messages')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.checkbox'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwPromotionalOpt','name' => 'whatsapp_opt_out','data-color' => '#ff0000','data-size' => 'small','value' => '1','data-lw-plugin' => 'lwSwitchery','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Opt out Marketing Messages'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493)): ?>
<?php $attributes = $__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493; ?>
<?php unset($__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal85a79a3f590ffcc2d6473eb3120eb493)): ?>
<?php $component = $__componentOriginal85a79a3f590ffcc2d6473eb3120eb493; ?>
<?php unset($__componentOriginal85a79a3f590ffcc2d6473eb3120eb493); ?>
<?php endif; ?>
                    </div>
                    <div class="my-3">
                        <?php if(isAiBotAvailable()): ?>
                        <?php if (isset($component)) { $__componentOriginal85a79a3f590ffcc2d6473eb3120eb493 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.checkbox','data' => ['id' => 'lwAiBotEnable','checked' => getVendorSettings('default_enable_flowise_ai_bot_for_users'),'name' => 'enable_ai_bot','value' => '1','dataSize' => 'small','dataLwPlugin' => 'lwSwitchery','label' => __tr('Enable AI Bot')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.checkbox'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwAiBotEnable','checked' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(getVendorSettings('default_enable_flowise_ai_bot_for_users')),'name' => 'enable_ai_bot','value' => '1','data-size' => 'small','data-lw-plugin' => 'lwSwitchery','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Enable AI Bot'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493)): ?>
<?php $attributes = $__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493; ?>
<?php unset($__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal85a79a3f590ffcc2d6473eb3120eb493)): ?>
<?php $component = $__componentOriginal85a79a3f590ffcc2d6473eb3120eb493; ?>
<?php unset($__componentOriginal85a79a3f590ffcc2d6473eb3120eb493); ?>
<?php endif; ?>
                        <?php endif; ?>
                    </div>
                    <div class="my-3">
                        <?php if (isset($component)) { $__componentOriginal85a79a3f590ffcc2d6473eb3120eb493 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.checkbox','data' => ['id' => 'lwReplyBotEnable','checked' => true,'name' => 'enable_reply_bot','value' => '1','dataSize' => 'small','dataLwPlugin' => 'lwSwitchery','label' => __tr('Enable Reply Bot')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.checkbox'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwReplyBotEnable','checked' => true,'name' => 'enable_reply_bot','value' => '1','data-size' => 'small','data-lw-plugin' => 'lwSwitchery','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Enable Reply Bot'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493)): ?>
<?php $attributes = $__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493; ?>
<?php unset($__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal85a79a3f590ffcc2d6473eb3120eb493)): ?>
<?php $component = $__componentOriginal85a79a3f590ffcc2d6473eb3120eb493; ?>
<?php unset($__componentOriginal85a79a3f590ffcc2d6473eb3120eb493); ?>
<?php endif; ?>
                    </div>
                    <fieldset>
                        <legend><?php echo e(__tr('Other Information')); ?></legend>
                        <?php $__currentLoopData = $vendorContactCustomFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendorContactCustomField): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => ''.e($vendorContactCustomField->input_type).'','id' => 'lwCustomField'.e($vendorContactCustomField->_id).'','dataFormGroupClass' => '','label' => $vendorContactCustomField->input_name,'name' => 'custom_input_fields['.e($vendorContactCustomField->_uid).']']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => ''.e($vendorContactCustomField->input_type).'','id' => 'lwCustomField'.e($vendorContactCustomField->_id).'','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($vendorContactCustomField->input_name),'name' => 'custom_input_fields['.e($vendorContactCustomField->_uid).']']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </fieldset>
                </div>
                <!-- form footer -->
                <div class="modal-footer">
                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-primary"><?php echo e(__tr('Submit')); ?></button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__tr('Close')); ?></button>
                </div>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $attributes = $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $component = $__componentOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
            <!--/  Add New Contact Form -->
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $attributes = $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $component = $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
        <!--/ Add New Contact Modal -->

        <!-- Details Contact Modal -->
        <?php if (isset($component)) { $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.modal','data' => ['id' => 'lwDetailsContact','header' => __tr('Contact Details')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwDetailsContact','header' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Contact Details'))]); ?>
            <!--  Details Contact Form -->
            <!-- Details body -->
            <div id="lwDetailsContactBody" class="lw-form-modal-body"></div>
            <script type="text/template" id="lwDetailsContactBody-template">
                <!-- form fields -->
                <div>
                    <label class="small"><?php echo e(__tr('First Name')); ?>:</label>
                    <div class="lw-details-item">
                        <%- __tData.first_name %>
                    </div>
                </div>

                <div>
                    <label class="small"><?php echo e(__tr('Last Name')); ?>:</label>
                    <div class="lw-details-item">
                        <%- __tData.last_name %>
                    </div>
                </div>

                <div>
                    <label class="small"><?php echo e(__tr('Country')); ?>:</label>
                    <div class="lw-details-item">
                        <%- __tData.country?.name %>
                    </div>
                </div>

                <div>
                    <label class="small"><?php echo e(__tr('Mobile Number')); ?>:</label>
                    <div class="lw-details-item">
                        <%- __tData.wa_id %>
                    </div>
                </div>
                <div>
                    <label class="small"><?php echo e(__tr('Language Code')); ?>:</label>
                    <div class="lw-details-item">
                        <%- __tData.language_code %>
                    </div>
                </div>

                <div>
                    <label class="small"><?php echo e(__tr('Email')); ?>:</label>
                    <div class="lw-details-item">
                        <%- __tData.email %>
                    </div>
                </div>

                <fieldset>
                    <legend><?php echo e(__tr('Groups')); ?></legend>
                    <% _.forEach(__tData.groups, function(value, key) { %>
                        <span class="badge badge-light">
                            <%- value.title %>
                        </span>
                        <% } ); %>
                </fieldset>
                <fieldset>
                    <legend><?php echo e(__tr('Other Information')); ?></legend>
                    <?php $__currentLoopData = $vendorContactCustomFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendorContactCustomField): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="mb-2">
                        <label class="small"><?php echo e($vendorContactCustomField->input_name); ?>:</label>
                        <div class="lw-details-item">
                            <%- _.get(_.find(__tData.custom_field_values, {'contact_custom_fields__id' : <?php echo e($vendorContactCustomField->_id); ?> }), 'field_value') %>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </fieldset>
            </script>
            <!--/  Details Contact Form -->
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $attributes = $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $component = $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
        <!--/ Edit Contact Modal -->

        <!--Group description -->
        <div class="ml-3">
            <p class="card-text"><?php echo e($groupDescription); ?></p>
        </div>
         <!--/ Group description -->
        <!-- Edit Contact Modal -->
        <?php echo $__env->make('contact.contact-edit-modal-partial', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <!--/ Edit Contact Modal -->
        <div class="col-xl-12" x-cloak x-data="{isSelectedAll:false,selectedContacts: [],selectedGroupsForSelectedContacts:[],
            toggle(id) {
                if (this.selectedContacts.includes(id)) {
                    const index = this.selectedContacts.indexOf(id);
                    this.selectedContacts.splice(index, 1);
                    this.isSelectedAll = false;
                } else {
                    this.selectedContacts.push(id);
                    if($('.dataTables_wrapper table>tbody input[type=checkbox].lw-checkboxes').length == this.selectedContacts.length) {
                        this.isSelectedAll = true;
                    }
                };
            },toggleAll() {
                if(!this.isSelectedAll) {
                    $('.dataTables_wrapper table>tbody input[type=checkbox].lw-checkboxes').not(':checked').trigger('click');
                    this.isSelectedAll = true;
                } else {
                    $('.dataTables_wrapper table>tbody input[type=checkbox].lw-checkboxes:checked').trigger('click');
                    this.isSelectedAll = false;
                }
            },deleteSelectedContacts() {
                var that = this;
                showConfirmation('<?php echo e(__tr('Are you sure you want to delete all selected contacts?')); ?>', function() {
                    __DataRequest.post('<?php echo e(route('vendor.contacts.selected.write.delete')); ?>', {
                        'selected_contacts' : that.selectedContacts
                    });
                }, {
                    confirmButtonText: '<?php echo e(__tr('Yes')); ?>',
                    cancelButtonText: '<?php echo e(__tr('No')); ?>',
                    type: 'error'
                });
            }, deleteAllContacts() {
                var that = this;
                showConfirmation('<?php echo e(__tr('WARNING - All your contacts will be deleted permanently, Are you sure you want to delete all your contacts?')); ?>', function() {
                    __DataRequest.post('<?php echo e(route('vendor.contacts.all.write.delete')); ?>', {});
                }, {
                    confirmButtonText: '<?php echo e(__tr('Yes')); ?>',
                    cancelButtonText: '<?php echo e(__tr('No')); ?>',
                    type: 'error'
                });
            }, assignGroupsToSelectedContacts(){
                var that = this;
                __DataRequest.post('<?php echo e(route('vendor.contacts.selected.write.assign_groups')); ?>', {
                    'selected_contacts' : that.selectedContacts,
                    'selected_groups' : that.selectedGroupsForSelectedContacts
                });
                $('#lwAssignGroups').modal('hide');
                $('.dataTables_wrapper table>tbody input[type=checkbox].lw-checkboxes:checked').trigger('click');
                this.isSelectedAll = false;
            }}" x-init="$('#lwContactList').on( 'draw.dt', function () {
                $('.dataTables_wrapper table>tbody input[type=checkbox].lw-checkboxes:checked').trigger('click');
                isSelectedAll = false;
            } );">
            <button x-show="!isSelectedAll" class="btn btn-dark btn-sm my-2" @click="toggleAll"><?php echo e(__tr('Select All')); ?></button>
            <button x-show="isSelectedAll" class="btn btn-dark btn-sm my-2" @click="toggleAll"><?php echo e(__tr('Unselect All')); ?></button>
            <div class="btn-group">
                <button :class="!selectedContacts.length ? 'disabled' : ''"
                    class="btn btn-danger mt-1 btn-sm dropdown-toggle" type="button" data-toggle="dropdown"
                    aria-expanded="false">
                    <?php echo e(__tr('Bulk Actions')); ?>

                </button>
                <div class="dropdown-menu">
                    <a class="dropdown-item" @click.prevent="deleteSelectedContacts" href="#"><?php echo e(__tr('Delete Selected Contacts')); ?></a>
                    <a class="dropdown-item" data-toggle="modal" data-target="#lwAssignGroups" href="#"><?php echo e(__tr('Assign Group to Selected Contacts')); ?></a>
                    <a class="dropdown-item lw-ajax-link-action" data-toggle="modal" data-target="#lwAssignTeamMember" data-response-template="#lwAssignTeamMemberBody" href="<?php echo e(route('vendor.team_member.read.list', ['contactIdOrUid' => 'bulk_action'])); ?>"><?php echo e(__tr('Assign Team Member')); ?></a>
                </div>
            </div>
            <?php if(!$groupUid): ?>
            <button class="btn btn-danger btn-sm my-2" @click.prevent="deleteAllContacts"><i class="fa fa-trash"></i> <?php echo e(__tr('Delete All Contact')); ?></button>
            <?php endif; ?>
            <!-- Assign Groups to the selected contacts -->
            <?php if (isset($component)) { $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.modal','data' => ['id' => 'lwAssignGroups','header' => __tr('Assign Groups to Selected Contacts'),'hasForm' => true,'dataPreCallback' => 'appFuncs.clearContainer']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwAssignGroups','header' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Assign Groups to Selected Contacts')),'hasForm' => true,'data-pre-callback' => 'appFuncs.clearContainer']); ?>
                <!-- form body -->
                <div class="lw-form-modal-body p-4">
                    <!-- form fields form fields -->
                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['xModel' => 'selectedGroupsForSelectedContacts','type' => 'selectize','dataLwPlugin' => 'lwSelectize','id' => 'lwSelectGroupsField','dataFormGroupClass' => '','dataSelected' => ' ','label' => __tr('Groups'),'name' => 'contact_groups[]','multiple' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['x-model' => 'selectedGroupsForSelectedContacts','type' => 'selectize','data-lw-plugin' => 'lwSelectize','id' => 'lwSelectGroupsField','data-form-group-class' => '','data-selected' => ' ','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Groups')),'name' => 'contact_groups[]','multiple' => true]); ?>
                         <?php $__env->slot('selectOptions', null, []); ?> 
                            <option value=""><?php echo e(__tr('Select Groups')); ?></option>
                            <?php $__currentLoopData = $vendorContactGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendorContactGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($vendorContactGroup['_id']); ?>"><?php echo e($vendorContactGroup['title']); ?> <?php echo e($vendorContactGroup['status'] == 5  ? __tr('(Archived)') : ''); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                         <?php $__env->endSlot(); ?>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                </div>
                <!-- form footer -->
                <div class="modal-footer">
                    <!-- Submit Button -->
                    <button type="button" @click="assignGroupsToSelectedContacts" class="btn btn-primary"><?php echo e(__tr('Submit')); ?></button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__tr('Close')); ?></button>
                </div>
                <!--/  Add New Contact Form -->
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $attributes = $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $component = $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
            <!--/ Assign Groups to the selected contacts -->

            <!-- Assign Team Member Modal -->
            <?php if (isset($component)) { $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.modal','data' => ['id' => 'lwAssignTeamMember','header' => __tr('Assign Team Member'),'hasForm' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwAssignTeamMember','header' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Assign Team Member')),'hasForm' => true]); ?>
                <div id="lwAssignTeamMemberBody" class="lw-form-modal-body"></div>
                <script type="text/template" id="lwAssignTeamMemberBody-template">                    
                    <?php if (isset($component)) { $__componentOriginald0b55ee435ec3aeeadffee8b0df479da = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.form','data' => ['id' => 'lwAssignTeamMemberForm','action' => route('vendor.chat.assign_user.process'),'dataCallbackParams' => ['modalId' => '#lwAssignTeamMember', 'datatableId' => '#lwContactList'],'dataCallback' => 'appFuncs.modelSuccessCallback']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwAssignTeamMemberForm','action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('vendor.chat.assign_user.process')),'data-callback-params' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['modalId' => '#lwAssignTeamMember', 'datatableId' => '#lwContactList']),'data-callback' => 'appFuncs.modelSuccessCallback']); ?>
                        <!-- form body -->
                        <div class="lw-form-modal-body">
                            <% if(__tData.is_bulk_action) { %>
                                <input type="hidden" name="contactIdOrUid" :value="selectedContacts">
                                <input type="hidden" name="bulk_action" :value="true">
                            <% } else { %>
                                <input type="hidden" name="contactIdOrUid" value="<%= __tData.contact._uid %>">
                            <% } %>
                            <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'selectize','dataLwPlugin' => 'lwSelectize','id' => 'lwSelectTeamMemberField','label' => __tr('Select Team Member'),'name' => 'assigned_users_uid','dataSelected' => '<%= __tData?.contact?.assigned_user?._uid %>']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'selectize','data-lw-plugin' => 'lwSelectize','id' => 'lwSelectTeamMemberField','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Select Team Member')),'name' => 'assigned_users_uid','data-selected' => '<%= __tData?.contact?.assigned_user?._uid %>']); ?>
                                 <?php $__env->slot('selectOptions', null, []); ?> 
                                    <option value="no_one"><?php echo e(__tr('Unassigned')); ?></option>
                                    <% _.forEach(__tData.teamMembers, function(item) {%>
                                        <option value="<%= item._uid %>">
                                            <%= item.first_name %> <%= item.last_name %> <% if(item._uid == __tData.userUID) { %> (<?php echo e(__tr('You')); ?>) <% } %>
                                        </option>
                                    <% }); %>
                                 <?php $__env->endSlot(); ?>
                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                        </div>
                        <!-- form footer -->
                        <div class="modal-footer">
                            <!-- Submit Button -->
                            <button type="submit" class="btn btn-primary"><?php echo e(__tr('Submit')); ?></button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__tr('Close')); ?></button>
                        </div>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $attributes = $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $component = $__componentOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
                </script>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $attributes = $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $component = $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
            <!-- Assign Team Member Modal -->
            
            <?php if (isset($component)) { $__componentOriginal49c2f9c26fb91807a4f87ab8f845e982 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.datatable','data' => ['dataPageLength' => '100','id' => 'lwContactList','url' => route('vendor.contact.read.list', [
                'groupUid' => $groupUid
            ])]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.datatable'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data-page-length' => '100','id' => 'lwContactList','url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('vendor.contact.read.list', [
                'groupUid' => $groupUid
            ]))]); ?>
                <th style="width: 1px;padding:0;" data-name="none"></th>
                <th data-name="none" data-template="#lwSelectMultipleContactsCheckbox"><?php echo e(__tr('Select')); ?></th>
                <th data-orderable="true" data-name="first_name"><?php echo e(__tr('First Name')); ?></th>
                <th data-orderable="true" data-name="last_name"><?php echo e(__tr('Last Name')); ?></th>
                <th data-orderable="true" data-name="phone_number"><?php echo e(__tr('Mobile Number')); ?></th>
                <th data-orderable="true" data-name="language_code"><?php echo e(__tr('Language Code')); ?></th>
                <th data-orderable="true" data-name="created_at"><?php echo e(__tr('Created on')); ?></th>
                <th data-name="country_name"><?php echo e(__tr('Country')); ?></th>
                <th data-orderable="true" data-name="email"><?php echo e(__tr('Email')); ?></th>
                <th data-orderable="true" data-name="whatsapp_opt_out"><?php echo e(__tr('Marketing')); ?></th>
                <th  data-name="groups"><?php echo e(__tr('Groups')); ?></th>
                <?php if(isAiBotAvailable()): ?>
                <th data-orderable="true" data-name="disable_ai_bot"><?php echo e(__tr('AI Bot')); ?></th>
                <?php endif; ?>
                <th data-template="#contactActionColumnTemplate" name="null"><?php echo e(__tr('Action')); ?></th>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982)): ?>
<?php $attributes = $__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982; ?>
<?php unset($__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal49c2f9c26fb91807a4f87ab8f845e982)): ?>
<?php $component = $__componentOriginal49c2f9c26fb91807a4f87ab8f845e982; ?>
<?php unset($__componentOriginal49c2f9c26fb91807a4f87ab8f845e982); ?>
<?php endif; ?>
        </div>
        <!-- action template -->
        <script type="text/template" id="lwSelectMultipleContactsCheckbox">
            <input @click="toggle('<%- __tData._uid %>')" type="checkbox" name="selected_contacts[]" class="lw-checkboxes custom-checkbox" value="<%- __tData._uid %>">
        </script>
        <script type="text/template" id="contactActionColumnTemplate">
            <a data-pre-callback="appFuncs.clearContainer" title="<?php echo e(__tr('Details')); ?>" class="lw-btn btn btn-sm btn-default lw-ajax-link-action" data-response-template="#lwDetailsContactBody" href="<%= __Utils.apiURL("<?php echo e(route('vendor.contact.read.update.data', [ 'contactIdOrUid'])); ?>", {'contactIdOrUid': __tData._uid}) %>"  data-toggle="modal" data-target="#lwDetailsContact"><i class="fa fa-info-circle"></i> <?php echo e(__tr('Details')); ?></a>
            <a data-pre-callback="appFuncs.clearContainer" title="<?php echo e(__tr('Edit')); ?>" class="lw-btn btn btn-sm btn-default lw-ajax-link-action" data-response-template="#lwEditContactBody" href="<%= __Utils.apiURL("<?php echo e(route('vendor.contact.read.update.data', [ 'contactIdOrUid'])); ?>", {'contactIdOrUid': __tData._uid}) %>"  data-toggle="modal" data-target="#lwEditContact"><i class="fa fa-edit"></i> <?php echo e(__tr('Edit')); ?></a>
<!--  Delete Action -->
<?php if(hasVendorAccess('messaging')): ?>
<a data-pre-callback="appFuncs.clearContainer" title="<?php echo e(__tr('Send Template Message')); ?>" class="lw-btn btn btn-sm btn-primary" href="<%= __Utils.apiURL("<?php echo e(route('vendor.template_message.contact.view', ['contactUid'])); ?>",{'contactUid': __tData._uid}) %>"><i class="fab fa-whatsapp"></i> <?php echo e(__tr('Send Template Message')); ?></a> <a data-pre-callback="appFuncs.clearContainer" title="<?php echo e(__tr('Chat')); ?>" class="lw-btn btn btn-sm btn-primary" href="<%= __Utils.apiURL("<?php echo e(route('vendor.chat_message.contact.view', ['contactUid'])); ?>",{'contactUid': __tData._uid}) %>"><i class="fab fa-whatsapp"></i> <?php echo e(__tr('Chat')); ?></a>
<?php endif; ?>
 <a data-method="post" href="<%= __Utils.apiURL("<?php echo e(route('vendor.contact.write.delete', [ 'contactIdOrUid'])); ?>", {'contactIdOrUid': __tData._uid}) %>" class="btn btn-danger btn-sm lw-ajax-link-action-via-confirm" data-confirm="#lwDeleteContact-template" title="<?php echo e(__tr('Delete')); ?>" data-callback-params="<?php echo e(json_encode(['datatableId' => '#lwContactList'])); ?>" data-callback="appFuncs.modelSuccessCallback"><i class="fa fa-trash"></i> <?php echo e(__tr('Delete')); ?></a>
 <!--  Remove Contact Action -->
 <?php if($currentGroup!=null): ?>
  <a data-method="post" href="<%= __Utils.apiURL("<?php echo e(route('vendor.contact.write.remove',['contactIdOrUid', 'groupUid' => $groupUid])); ?>",{ 'contactIdOrUid': __tData._uid }) %>" class="btn btn-warning btn-sm lw-ajax-link-action-via-confirm" data-confirm="#lwRemoveContact-template" title="<?php echo e(__tr('Remove contact from group')); ?>" data-callback-params="<?php echo e(json_encode(['datatableId' => '#lwContactList'])); ?>" data-callback="appFuncs.modelSuccessCallback"><i class="fa fa-user-times"></i> <?php echo e(__tr('Remove')); ?></a> 
 <?php endif; ?>

 <a data-pre-callback="appFuncs.clearContainer" title="<?php echo e(__tr('Assign')); ?>" class="lw-btn btn btn-sm btn-default lw-ajax-link-action" data-response-template="#lwAssignTeamMemberBody" href="<%= __Utils.apiURL("<?php echo e(route('vendor.team_member.read.list', [ 'contactIdOrUid'])); ?>", {'contactIdOrUid': __tData._uid}) %>" data-toggle="modal" data-target="#lwAssignTeamMember"><i class="fa fa-user-check"></i> <?php echo e(__tr('Assign')); ?></a>

 <% if (__tData.is_blocked) { %>
    <a data-method="post" href="<%= __Utils.apiURL("<?php echo e(route('vendor.contact.write.unblock', [ 'contactIdOrUid'])); ?>", {'contactIdOrUid': __tData._uid}) %>" class="btn btn-danger btn-sm lw-ajax-link-action-via-confirm" data-confirm="#lwUnblockContact-template" title="<?php echo e(__tr('WA Unblock')); ?>" data-callback-params="<?php echo e(json_encode(['datatableId' => '#lwContactList'])); ?>" data-callback="appFuncs.modelSuccessCallback"><i class="fa fa-ban"></i> <?php echo e(__tr('WA Unblock')); ?></a>
<% } %>
<% if(!__tData.is_blocked && __tData.is_direct_message_delivery_window_opened) { %>
    <a data-method="post" href="<%= __Utils.apiURL("<?php echo e(route('vendor.contact.write.block', [ 'contactIdOrUid'])); ?>", {'contactIdOrUid': __tData._uid}) %>" class="btn btn-danger btn-sm lw-ajax-link-action-via-confirm" data-confirm="#lwBlockContact-template" title="<?php echo e(__tr('WA Block')); ?>" data-callback-params="<?php echo e(json_encode(['datatableId' => '#lwContactList'])); ?>" data-callback="appFuncs.modelSuccessCallback"><i class="fa fa-ban"></i> <?php echo e(__tr('WA Block')); ?></a>
<% } %>
 
 <!--  Remove Contact Action  -->
    </script>
        <!-- /action template -->
        <!-- Contact delete template -->
        <script type="text/template" id="lwDeleteContact-template">
            <h2><?php echo e(__tr('Are You Sure!')); ?></h2>
            <p><?php echo e(__tr('You want to delete this Contact permanently?')); ?></p>
        </script>
        <!-- /Contact delete template -->

         <!-- Contact remove template -->
         <script type="text/template" id="lwRemoveContact-template">
            <h2><?php echo e(__tr('Are You Sure!')); ?></h2>
            <p><?php echo e(__tr('You want to remove this Contact from this group?')); ?></p>
        </script>
        <!-- /Contact remove template -->

        <!-- Contact block template -->
        <script type="text/template" id="lwBlockContact-template">
            <h2><?php echo e(__tr('Are You Sure!')); ?></h2>
            <p><?php echo e(__tr('You want to block this Contact?')); ?></p>
        </script>
        <!-- /Contact block template -->

        <!-- Contact unblock template -->
        <script type="text/template" id="lwUnblockContact-template">
            <h2><?php echo e(__tr('Are You Sure!')); ?></h2>
            <p><?php echo e(__tr('You want to unblock this Contact?')); ?></p>
        </script>
        <!-- /Contact unblock template -->
    </div>
</div>
<script>
(function() {
    'use strict';
        document.addEventListener('alpine:init', () => {
                Alpine.data('initialContactsInfoData', () => ({
                    existingImportRequestData: <?php echo json_encode(getVendorSettings('contacts_import_process_data') ?: [], 15, 512) ?>,
            }));
        });
    })();
</script>
<?php $__env->startPush('appScripts'); ?>
<script>
(function($) {
    'use strict';
    window.onUpdateContactDetails = function(responseData, callbackParams) {
        appFuncs.modelSuccessCallback(responseData, callbackParams);
    };
    window.onImportProcessUpdate = function(responseData, callbackParams) {
        if((responseData.reaction == 1) || (responseData === true)) {
            if(_.get(responseData, 'data.progressCount') === 0) {
                // close modal
                appFuncs.modelSuccessCallback(responseData, callbackParams);
            } else if(_.get(responseData, 'data.progressCount') || (responseData === true))  {
                __DataRequest.post('<?php echo e(route('vendor.contact.write.import')); ?>', {
                    'document_name': 'existing'
                }, function(responseData) {
                     _.delay(function() {
                         window.onImportProcessUpdate(responseData, callbackParams);
                    },30);
                });
            } else {
                // close modal
                appFuncs.modelSuccessCallback(responseData, callbackParams);
            }
        }
    };
    var existingImportRequestExist = <?php echo e(getVendorSettings('contacts_import_process_data') ? 1 : 0); ?>;
    if(existingImportRequestExist) {
        _.delay(function() {
            window.onImportProcessUpdate(true);
        },300);
    };
})(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['title' => __tr('Contacts')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/workwatsup-new.jmd-infotech.in/resources/views/contact/list.blade.php ENDPATH**/ ?>