<!-- Page Heading -->

<h1><?= __tr('General Settings') ?></h1>
<!-- Page Heading -->
<hr>
<!-- General setting form -->
<form class="lw-ajax-form lw-form" method="post" action="<?= route('manage.configuration.write', ['pageType' => request()->pageType]) ?>">
<div class="row">
</div>
    <div class="">
        <div class="col-12">
            <div class="alert alert-default">
                <?php echo e(__tr('Upload will be processed automatically on valid selection.')); ?>

            </div>
        </div>
           <!-- Light Theme -->
        <fieldset>
            <legend><?php echo e(__tr('Dark / Light Theme')); ?></legend>
                <!-- Light Theme -->
                <h3><?= __tr('Light Theme') ?></h3>
                <div class=" row ">
                 <div class="col-lg-3">
                       <!-- upload logo -->
                   <div class="form-group">
                       <label for="lwUploadLogo"><?= __tr('Logo') ?></label>
                   <input type="file" data-lw-plugin="lwUploader" data-label-idle="<?php echo e(__tr('Select New Logo')); ?>" data-allow-revert="true" data-instant-upload="true" data-action="<?= route('media.upload_logo') ?>" id="lwUploadLogo" data-callback="afterUploadedFile" data-default-image-url="<?= getAppSettings('logo_image_url') ?>">
                   </div>
                    <!-- /upload logo -->
                 </div>
                 <div class="col-lg-2">
                     <!-- upload small logo -->
                    <div class="form-group ">
                       <label for="lwUploadSmallLogo"><?= __tr('Small Logo') ?></label>
                        <input type="file" data-lw-plugin="lwUploader" data-label-idle="<?php echo e(__tr('Select New Small Logo')); ?>" data-allow-revert="true" data-instant-upload="true" data-action="<?= route('media.upload_small_logo') ?>" id="lwUploadSmallLogo" data-callback="afterUploadedFile" data-default-image-url="<?= getAppSettings('small_logo_image_url') ?>">
                    </div>
                </div>
                    <!-- /upload small logo -->
                    <div class="col-lg-2">
                            <!-- upload favicon -->
                        <div class="form-group">
                            <label for="lwUploadFavicon"><?= __tr('Favicon') ?></label>
                            <input type="file" data-lw-plugin="lwUploader" data-label-idle="<?php echo e(__tr('Select New Favicon')); ?>" data-instant-upload="true" data-action="<?= route('media.upload_favicon') ?>" data-callback="afterUploadedFile" id="lwUploadFavicon" data-default-image-url="<?= getAppSettings('favicon_image_url') ?>">
                        </div>
                            <!-- /upload favicon -->
                    </div>
               </div>
               <!-- Light Theme -->
               <!-- Dark Theme -->
               <h3 class="mt-3"><?= __tr('Dark Theme') ?></h3>
               <div class="row">
                <div class="col-lg-3">
                     <!-- upload logo -->
                    <div class="form-group">
                        <label for="lwUploadDarkThemeLogo"><?= __tr('Logo') ?></label>
                    <input type="file" data-lw-plugin="lwUploader" data-label-idle="<?php echo e(__tr('Select New Logo')); ?>" data-allow-revert="true" data-instant-upload="true" data-action="<?= route('media.dark.theme.upload_logo') ?>" id="lwUploadDarkThemeLogo" data-callback="afterUploadedFile" data-default-image-url="<?= getAppSettings('dark_theme_logo_image_url') ?>">
                    </div>
                     <!-- /upload logo -->
                </div>
                <div class="col-lg-2">
                      <!-- upload small logo -->
                    <div class="form-group ">
                        <label for="lwUploadDarkThemeSmallLogo"><?= __tr('Small Logo') ?></label>
                    <input type="file" data-lw-plugin="lwUploader" data-label-idle="<?php echo e(__tr('Select New Small Logo')); ?>" data-allow-revert="true" data-instant-upload="true" data-action="<?= route('media.dark.theme.upload_small_logo') ?>" id="lwUploadDarkThemeSmallLogo" data-callback="afterUploadedFile" data-default-image-url="<?= getAppSettings('dark_theme_small_logo_image_url') ?>">
                    </div>
                </div>
                     <!-- /upload small logo -->
                     <div class="col-lg-2">
                      <!-- upload favicon -->
                    <div class="form-group">
                        <label for="lwUploadDarkThemeFavicon"><?= __tr('Favicon') ?></label>
                        <input type="file" data-lw-plugin="lwUploader" data-label-idle="<?php echo e(__tr('Select New Favicon')); ?>" data-instant-upload="true" data-action="<?= route('media.dark.theme.upload_favicon') ?>" data-callback="afterUploadedFile" id="lwUploadDarkThemeFavicon" data-default-image-url="<?= getAppSettings('dark_theme_favicon_image_url') ?>">
                    </div>
                </div>
                     <!-- /upload favicon -->
                </div>
        <!-- Dark Theme -->
        </fieldset>
           <!-- /Light Theme -->
    </div>

    <hr>
    <!-- Website Name -->
    <div class="form-group">
        <label for="lwWebsiteName"><?= __tr('Your Website Name') ?></label>
        <input type="text" class="form-control form-control-user" name="name" id="lwWebsiteName" value="<?= $configurationData['name'] ?>" required>
    </div>
    <!-- /Website Name -->
    <!-- Website Description -->
    <div class="form-group">
        <label for="lwWebsiteDescription"><?= __tr('Your Website Description') ?></label>
        <textarea name="description" id="lwWebsiteDescription" class="form-control" rows="2"><?= $configurationData['description'] ?></textarea>
    </div>
    <!-- /Website Description -->

    <fieldset>
        <legend><?php echo e(__tr('Contact Settings')); ?></legend>
            <!-- Contact Email -->
        <div class="form-group">
            <label for="lwContactEmail"><?= __tr('Contact Email') ?></label>
            <input type="email" class="form-control form-control-user" name="contact_email" id="lwContactEmail" value="<?= $configurationData['contact_email'] ?>">
            <small class="help-text"><?php echo e(__tr('It will be used to receive contact form emails')); ?></small>
        </div>
        <!-- /Contact Email -->
        <!-- Contact details -->
        <div class="form-group">
            <label for="lwContactDetails"><?= __tr('Contact Details') ?></label>
            <textarea class="form-control form-control-user" name="contact_details" rows="4" id="lwContactDetails"><?php echo $configurationData['contact_details']; ?></textarea>
            <small class="help-text"><?php echo e(__tr('Details added here will be shown on contact page')); ?></small>
        </div>
        <!-- /Contact details -->
    </fieldset>

    <fieldset>
        <legend><?php echo e(__tr('Localization')); ?></legend>
        <!-- Select Timezone -->
    <div class="form-group">
        <label for="lwSelectTimezone"><?= __tr('Select Timezone') ?></label>
        <select data-lw-plugin="lwSelectize" data-label-field="name" data-selected="<?php echo e($configurationData['timezone']); ?>" data-search-field="<?php echo e(json_encode(['id','name'])); ?>" data-value-field="id" id="lwSelectTimezone" class="form-control form-control-user" name="timezone" required>
            <?php $__currentLoopData = $configurationData['timezone_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?= $timezone['value'] ?>"><?= $timezone['text'] ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <!-- /Select Timezone -->

    <!-- Select Default language -->
    <div class="form-group mt-2">
        <label for="lwSelectDefaultLanguage"><?= __tr('Default Language') ?></label>
        <select id="lwSelectDefaultLanguage" data-lw-plugin="lwSelectize" placeholder="Default Language..." name="default_language">
            <?php if(!__isEmpty($configurationData['languageList'])): ?>
            <?php $__currentLoopData = $configurationData['languageList']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?= $language['id'] ?>" <?= $configurationData['default_language'] == $language['id'] ? 'selected' : '' ?> required><?= $language['name'] ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </select>
    </div>
    <!-- /Select Default language -->
    
    </fieldset>
    <!-- Update Button -->
   <div class="mt-4">
    <a href class="lw-ajax-form-submit-action btn btn-primary btn-user lw-btn-block-mobile">
        <?= __tr('Save') ?>
    </a>
   </div>
    <!-- /Update Button -->
</form>
<!-- /General setting form -->
<?php $__env->startPush('appScripts'); ?>
<script>
    (function($) {
        'use strict';
    // After file successfully uploaded then this function is called
    window.afterUploadedFile = function (responseData) {
        var requestData = responseData.data;
        $('#lwUploadedLogo').attr('src', requestData.path);
    }
    })(jQuery);

   
</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/u248210191/domains/shivamenterprisesse.in/public_html/oldwaba/resources/views/configuration/general.blade.php ENDPATH**/ ?>