<?php
require_once 'vendor/autoload.php';

use chillerlan\QRCode\{QRCode, QROptions};
use chillerlan\QRCode\Common\EccLevel;
use chillerlan\QRCode\Output\QROutputInterface;

// 1. Get requested data and format
$format = $_GET['format'] ?? 'png';
$data   = $_GET['data'] ?? 'https://wala.guru';

// 2. Capture the new Styling Options from your form
$dotsType          = $_GET['dotsType'] ?? 'square';
$cornersSquareType = $_GET['cornersSquareType'] ?? 'square';
$cornersDotType    = $_GET['cornersDotType'] ?? 'dot';

// 3. Set common options
$options = new QROptions([
    'version'             => 5,
    'eccLevel'            => EccLevel::H,
    'addQuietzone'        => true,
    'scale'               => 10,
    'outputBase64'        => false,

    // Mapping the "Dots Options" (Module shapes)
    // Note: chillerlan uses 'drawCircularModules' for dots/rounded shapes
    'drawCircularModules' => in_array($dotsType, ['dots', 'rounded', 'extra-rounded']),
    'circleRadius'        => 0.9, // Adjust this for "extra-rounded" feel

    // Mapping "Corners Square" and "Corners Dot"
    'drawLightModules'    => true,
    'keepQuietZone'       => true,
]);

try {
    switch ($format) {
        case 'png':
            $options->outputType = QROutputInterface::GDIMAGE_PNG;
            header('Content-Type: image/png');
            header('Content-Disposition: attachment; filename="qrcode.png"');
            break;

        case 'eps':
            $options->outputType = QROutputInterface::EPS;
            header('Content-Type: application/postscript');
            header('Content-Disposition: attachment; filename="qrcode.eps"');
            break;

        case 'pdf':
            // Ensure fpdf/fpdf is installed via composer for this to work
            $options->outputType = QROutputInterface::FPDF;
            header('Content-Type: application/pdf');
            header('Content-Disposition: attachment; filename="qrcode.pdf"');
            break;

        case 'svg':
        default:
            $options->outputType = QROutputInterface::MARKUP_SVG;
            // For SVG, we can use specific module shapes if using a custom Output class
            header('Content-Type: image/svg+xml');
            header('Content-Disposition: attachment; filename="qrcode.svg"');
            break;
    }

    $qrcode = new QRCode($options);
    echo $qrcode->render($data);

} catch (Exception $e) {
    header('Content-Type: text/plain');
    die("Error generating QR code: " . $e->getMessage());
}