<?php require_once __DIR__ . '/header.php'; ?>

    <style>
        .control-group { margin-bottom: 20px; padding: 15px; border-bottom: 1px solid #eee; }
        .color-row { display: flex; gap: 10px; align-items: center; margin-bottom: 10px; }
        #qr-canvas canvas, #qr-canvas svg { max-width: 100%; height: auto !important; box-shadow: 0 10px 25px rgba(0,0,0,0.1); border-radius: 10px; }
        .nav-tabs .nav-link { color: #4a6fa5; font-weight: 600; }
        .nav-tabs .nav-link.active { border-bottom: 3px solid #4a6fa5; }
        .qr-input-group { margin-top: 15px; }
    </style>

    <div class="container-fluid py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="card shadow-sm border-0">
                        <div class="card-header bg-white pt-3">
                            <ul class="nav nav-tabs card-header-tabs" id="qrTabs" role="tablist">
                                <li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#content">Content</a></li>
                                <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#dots">Dots</a></li>
                                <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#corners">Corners</a></li>
                                <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#background">Background</a></li>
                                <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#image">Logo</a></li>
                            </ul>
                        </div>
                        <div class="card-body tab-content p-4">

                            <div class="tab-pane fade show active" id="content">
                                <label class="form-label fw-bold">Select QR Type</label>
                                <select id="qr-type-selector" class="form-select mb-3" onchange="toggleInputFields()">
                                    <option value="url">Website URL</option>
                                    <option value="pdf">PDF File</option>
                                    <option value="multi">Multi-URL (Smart Link)</option>
                                    <option value="vcard">Contact (vCard)</option>
                                    <option value="text">Plain Text</option>
                                    <option value="app">App Store / Play Store</option>
                                    <option value="sms">SMS</option>
                                    <option value="email">Email</option>
                                    <option value="phone">Phone Call</option>
                                </select>

                                <div id="input-fields-container">
                                    <div class="qr-input-group" id="group-url">
                                        <label class="form-label">Website URL</label>
                                        <input type="url" id="input-url" class="form-control" placeholder="https://example.com" value="https://wala.guru">
                                    </div>

                                    <div class="qr-input-group d-none" id="group-pdf">
                                        <label class="form-label">Upload PDF</label>
                                        <input type="file" id="input-pdf" class="form-control" accept=".pdf">
                                        <small class="text-muted">Dynamic QR: The code will link to this document on our server.</small>
                                    </div>

                                    <div class="qr-input-group d-none" id="group-multi">
                                        <label class="form-label">Smart Redirect Link</label>
                                        <input type="url" id="input-multi" class="form-control" placeholder="Enter your smart link URL">
                                    </div>

                                    <div class="qr-input-group d-none" id="group-vcard">
                                        <div class="row">
                                            <div class="col-6 mb-2"><label>First Name</label><input type="text" id="v-fn" class="form-control"></div>
                                            <div class="col-6 mb-2"><label>Last Name</label><input type="text" id="v-ln" class="form-control"></div>
                                            <div class="col-12 mb-2"><label>Organization</label><input type="text" id="v-org" class="form-control"></div>
                                            <div class="col-12 mb-2"><label>Phone</label><input type="tel" id="v-phone" class="form-control"></div>
                                            <div class="col-12 mb-2"><label>Email</label><input type="email" id="v-email" class="form-control"></div>
                                        </div>
                                    </div>

                                    <div class="qr-input-group d-none" id="group-text">
                                        <label class="form-label">Message</label>
                                        <textarea id="input-text" class="form-control" rows="3"></textarea>
                                    </div>

                                    <div class="qr-input-group d-none" id="group-app">
                                        <label class="form-label">App Link (Store URL)</label>
                                        <input type="url" id="input-app" class="form-control" placeholder="https://apps.apple.com/...">
                                    </div>

                                    <div class="qr-input-group d-none" id="group-sms">
                                        <label class="form-label">Phone Number</label>
                                        <input type="tel" id="input-sms-phone" class="form-control mb-2">
                                        <label class="form-label">Message</label>
                                        <textarea id="input-sms-msg" class="form-control"></textarea>
                                    </div>

                                    <div class="qr-input-group d-none" id="group-email">
                                        <label class="form-label">Recipient Email</label>
                                        <input type="email" id="input-email-to" class="form-control mb-2">
                                        <label class="form-label">Subject</label>
                                        <input type="text" id="input-email-sub" class="form-control">
                                    </div>

                                    <div class="qr-input-group d-none" id="group-phone">
                                        <label class="form-label">Phone Number</label>
                                        <input type="tel" id="input-phone-only" class="form-control" placeholder="+1234567890">
                                    </div>
                                </div>

                                <div class="row mt-4 pt-3 border-top">
                                    <div class="col-md-6">
                                        <label class="form-label">Margin</label>
                                        <input type="number" id="qr-margin" class="form-control" value="10">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Error Correction</label>
                                        <select id="qr-ecc" class="form-select">
                                            <option value="L">L (7%)</option>
                                            <option value="M">M (15%)</option>
                                            <option value="Q" selected>Q (25%)</option>
                                            <option value="H">H (30%)</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="dots">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Dot Style</label>
                                        <select id="dot-type" class="form-select">
                                            <option value="square">Square</option>
                                            <option value="dots">Dots</option>
                                            <option value="rounded">Rounded</option>
                                            <option value="extra-rounded">Extra Rounded</option>
                                            <option value="classy">Classy</option>
                                            <option value="classy-rounded">Classy Rounded</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Color Type</label>
                                        <select id="dot-color-type" class="form-select" onchange="toggleGradient('dot')">
                                            <option value="single">Single Color</option>
                                            <option value="gradient">Gradient</option>
                                        </select>
                                    </div>
                                </div>
                                <div id="dot-single-color">
                                    <label class="form-label">Color</label>
                                    <input type="color" id="dot-color" class="form-control form-control-color w-100" value="#4267b2">
                                </div>
                                <div id="dot-gradient-options" class="d-none">
                                    <div class="row">
                                        <div class="col-6"><label>Color 1</label><input type="color" id="dot-grad-1" class="form-control form-control-color w-100" value="#4267b2"></div>
                                        <div class="col-6"><label>Color 2</label><input type="color" id="dot-grad-2" class="form-control form-control-color w-100" value="#1a2a6c"></div>
                                    </div>
                                    <label class="mt-2">Type</label>
                                    <select id="dot-grad-type" class="form-select mb-2"><option value="linear">Linear</option><option value="radial">Radial</option></select>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="corners">
                                <h6 class="fw-bold">Corner Square</h6>
                                <select id="corner-sq-type" class="form-select mb-3">
                                    <option value="square">Square</option><option value="dot">Dot</option><option value="extra-rounded">Extra Rounded</option>
                                </select>
                                <input type="color" id="corner-sq-color" class="form-control form-control-color mb-3 w-100" value="#000000">

                                <h6 class="fw-bold mt-4">Corner Dot</h6>
                                <select id="corner-dot-type" class="form-select mb-3">
                                    <option value="square">Square</option><option value="dot">Dot</option>
                                </select>
                                <input type="color" id="corner-dot-color" class="form-control form-control-color w-100" value="#000000">
                            </div>

                            <div class="tab-pane fade" id="background">
                                <label class="form-label">Background Color</label>
                                <input type="color" id="bg-color" class="form-control form-control-color w-100 mb-3" value="#ffffff">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="bg-transparent">
                                    <label class="form-check-label">Transparent Background (SVG only)</label>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="image">
                                <label class="form-label">Upload Logo</label>
                                <input type="file" id="logo-file" class="form-control mb-3" accept="image/*">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="form-label">Logo Size (%)</label>
                                        <input type="range" id="logo-size" class="form-range" min="0.1" max="0.5" step="0.05" value="0.4">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Logo Margin</label>
                                        <input type="number" id="logo-margin" class="form-control" value="10">
                                    </div>
                                </div>
                                <div class="form-check mt-3">
                                    <input class="form-check-input" type="checkbox" id="hide-dots" checked>
                                    <label class="form-check-label">Hide dots behind logo</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="card shadow border-0 sticky-top" style="top: 20px;">
                        <div class="card-body text-center py-5">
                            <div id="qr-canvas" class="mb-4"></div>
                            <div class="d-grid gap-2">
                                <button class="btn btn-dark btn-lg" onclick="download('png')">Download PNG</button>
                                <div class="btn-group">
                                    <button class="btn btn-outline-dark" onclick="download('svg')">SVG</button>
                                    <button class="btn btn-outline-dark" onclick="downloadPDF()">PDF</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript" src="https://unpkg.com/qr-code-styling@1.5.0/lib/qr-code-styling.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

    <script>
        // Initialize QR Instance
        const qrCode = new QRCodeStyling({
            width: 300, height: 300,
            type: "svg",
            data: "https://wala.guru",
            dotsOptions: { color: "#4267b2", type: "square" },
            backgroundOptions: { color: "#ffffff" },
            imageOptions: { crossOrigin: "anonymous", margin: 10 }
        });

        qrCode.append(document.getElementById("qr-canvas"));

        // Toggle UI based on selected type
        function toggleInputFields() {
            const selectedType = document.getElementById('qr-type-selector').value;
            document.querySelectorAll('.qr-input-group').forEach(group => group.classList.add('d-none'));
            document.getElementById(`group-${selectedType}`).classList.remove('d-none');
            updateQR();
        }

        // Format data based on type (URL, SMS, VCard, etc.)
        function getFormattedData() {
            const type = document.getElementById('qr-type-selector').value;
            switch(type) {
                case 'url': return document.getElementById('input-url').value;
                case 'text': return document.getElementById('input-text').value;
                case 'app': return document.getElementById('input-app').value;
                case 'multi': return document.getElementById('input-multi').value;
                case 'phone': return `tel:${document.getElementById('input-phone-only').value}`;
                case 'sms':
                    return `smsto:${document.getElementById('input-sms-phone').value}:${document.getElementById('input-sms-msg').value}`;
                case 'email':
                    return `mailto:${document.getElementById('input-email-to').value}?subject=${encodeURIComponent(document.getElementById('input-email-sub').value)}`;
                case 'vcard':
                    const fn = document.getElementById('v-fn').value;
                    const ln = document.getElementById('v-ln').value;
                    const org = document.getElementById('v-org').value;
                    const phone = document.getElementById('v-phone').value;
                    const email = document.getElementById('v-email').value;
                    return `BEGIN:VCARD\nVERSION:3.0\nN:${ln};${fn}\nFN:${fn} ${ln}\nORG:${org}\nTEL:${phone}\nEMAIL:${email}\nEND:VCARD`;
                case 'pdf':
                    // In a live system, this link is generated after the file is uploaded via AJAX
                    return "https://wala.guru/files/sample.pdf";
                default: return "https://wala.guru";
            }
        }

        function toggleGradient(prefix) {
            const type = document.getElementById(`${prefix}-color-type`).value;
            document.getElementById(`${prefix}-single-color`).classList.toggle('d-none', type === 'gradient');
            document.getElementById(`${prefix}-gradient-options`).classList.toggle('d-none', type === 'single');
            updateQR();
        }

        async function updateQR() {
            const fileInput = document.getElementById('logo-file');
            let logoData = qrCode._options.image;

            if (fileInput.files[0]) {
                logoData = await new Promise(resolve => {
                    const reader = new FileReader();
                    reader.onload = e => resolve(e.target.result);
                    reader.readAsDataURL(fileInput.files[0]);
                });
            }

            const options = {
                data: getFormattedData(),
                margin: parseInt(document.getElementById('qr-margin').value),
                qrOptions: { errorCorrectionLevel: document.getElementById('qr-ecc').value },
                backgroundOptions: {
                    color: document.getElementById('bg-transparent').checked ? 'transparent' : document.getElementById('bg-color').value
                },
                dotsOptions: {
                    type: document.getElementById('dot-type').value,
                    color: document.getElementById('dot-color-type').value === 'single' ? document.getElementById('dot-color').value : undefined,
                    gradient: document.getElementById('dot-color-type').value === 'gradient' ? {
                        type: document.getElementById('dot-grad-type').value,
                        colorStops: [
                            { offset: 0, color: document.getElementById('dot-grad-1').value },
                            { offset: 1, color: document.getElementById('dot-grad-2').value }
                        ]
                    } : undefined
                },
                cornersSquareOptions: {
                    type: document.getElementById('corner-sq-type').value,
                    color: document.getElementById('corner-sq-color').value
                },
                cornersDotOptions: {
                    type: document.getElementById('corner-dot-type').value,
                    color: document.getElementById('corner-dot-color').value
                },
                image: logoData,
                imageOptions: {
                    hideBackgroundDots: document.getElementById('hide-dots').checked,
                    imageSize: parseFloat(document.getElementById('logo-size').value),
                    margin: parseInt(document.getElementById('logo-margin').value)
                }
            };

            qrCode.update(options);
        }

        document.querySelectorAll('input, select, textarea').forEach(el => {
            el.addEventListener('input', updateQR);
        });

        function download(ext) {
            qrCode.download({ name: "wala-qr", extension: ext });
        }

        async function downloadPDF() {
            const { jsPDF } = window.jspdf;
            const doc = new jsPDF();
            const rawData = await qrCode.getRawData("png");
            const reader = new FileReader();
            reader.readAsDataURL(rawData);
            reader.onloadend = function() {
                doc.setFontSize(20);
                doc.text("Professional QR Code", 105, 30, { align: "center" });
                doc.addImage(reader.result, 'PNG', 55, 50, 100, 100);
                doc.save("qr-code.pdf");
            }
        }
    </script>

<?php require_once __DIR__ . '/footer.php'; ?>