<?php
require_once __DIR__ . '/../../app/middleware/Auth.php';
$auth = new Auth();
$user = $auth->requireAdmin();

require_once __DIR__ . '/../../app/models/User.php';
require_once __DIR__ . '/../../app/models/QrCode.php';
require_once __DIR__ . '/../../app/models/Analytics.php';

$userModel = new User();
$qrModel = new QrCode();
$analyticsModel = new Analytics();

// Get dashboard statistics
$total_users = $userModel->getTotalCount();
$total_qr_codes = $qrModel->getTotalCount();
$total_scans = $analyticsModel->getTotalScans();
$recent_users = $userModel->getRecentUsers(5);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - <?php echo SITE_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            background-color: #f5f7fa;
        }

        .sidebar {
            background: #2d3e50;
            color: white;
            min-height: 100vh;
            position: fixed;
            width: 250px;
        }

        .main-content {
            margin-left: 250px;
            padding: 20px;
        }

        .sidebar .nav-link {
            color: #adb5bd;
            padding: 12px 20px;
            border-left: 3px solid transparent;
            transition: all 0.3s;
        }

        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
            border-left-color: #4fc3a1;
        }

        .admin-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            margin-bottom: 20px;
        }

        .stat-card {
            text-align: center;
            padding: 20px;
        }

        .stat-number {
            font-size: 2.5rem;
            font-weight: bold;
            color: #4a6fa5;
            line-height: 1;
        }

        .stat-label {
            color: #6c757d;
            font-size: 0.9rem;
            margin-top: 5px;
        }

        .table th {
            border-top: none;
            background: #f8f9fa;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #4a6fa5;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }
    </style>
</head>
<body>
<!-- Sidebar -->
<div class="sidebar">
    <div class="p-4">
        <h4 class="mb-4">
            <i class="fas fa-qrcode me-2"></i><?php echo SITE_NAME; ?>
            <span class="badge bg-danger ms-2">Admin</span>
        </h4>

        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link active" href="dashboard.php">
                    <i class="fas fa-tachometer-alt me-2"></i> Dashboard
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="users.php">
                    <i class="fas fa-users me-2"></i> Users
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="qr-codes.php">
                    <i class="fas fa-qrcode me-2"></i> QR Codes
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="analytics.php">
                    <i class="fas fa-chart-line me-2"></i> Analytics
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="templates.php">
                    <i class="fas fa-palette me-2"></i> Templates
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="settings.php">
                    <i class="fas fa-cog me-2"></i> Settings
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="reports.php">
                    <i class="fas fa-file-alt me-2"></i> Reports
                </a>
            </li>
            <li class="nav-item mt-4">
                <a class="nav-link text-danger" href="<?php echo SITE_URL; ?>logout.php">
                    <i class="fas fa-sign-out-alt me-2"></i> Logout
                </a>
            </li>
        </ul>
    </div>
</div>

<!-- Main Content -->
<div class="main-content">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Admin Dashboard</h1>
        <div class="d-flex align-items-center">
            <span class="me-3">Welcome, <?php echo htmlspecialchars($user['full_name']); ?></span>
            <span class="badge bg-info">Last login: <?php echo date('Y-m-d H:i'); ?></span>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="admin-card stat-card">
                <div class="stat-number"><?php echo number_format($total_users); ?></div>
                <div class="stat-label">Total Users</div>
                <div class="mt-3">
                    <span class="badge bg-success">+5% this month</span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="admin-card stat-card">
                <div class="stat-number"><?php echo number_format($total_qr_codes); ?></div>
                <div class="stat-label">QR Codes</div>
                <div class="mt-3">
                    <span class="badge bg-warning text-dark">+12% this month</span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="admin-card stat-card">
                <div class="stat-number"><?php echo number_format($total_scans); ?></div>
                <div class="stat-label">Total Scans</div>
                <div class="mt-3">
                    <span class="badge bg-info">+8% this month</span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="admin-card stat-card">
                <div class="stat-number">98.5%</div>
                <div class="stat-label">Uptime</div>
                <div class="mt-3">
                    <span class="badge bg-success">System Healthy</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row mb-4">
        <div class="col-md-8">
            <div class="admin-card">
                <h5 class="mb-4">Monthly Activity</h5>
                <canvas id="activityChart" height="250"></canvas>
            </div>
        </div>
        <div class="col-md-4">
            <div class="admin-card">
                <h5 class="mb-4">User Distribution</h5>
                <canvas id="userChart" height="250"></canvas>
            </div>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="row">
        <div class="col-md-6">
            <div class="admin-card">
                <h5 class="mb-4">Recent Users</h5>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                        <tr>
                            <th>User</th>
                            <th>Email</th>
                            <th>Plan</th>
                            <th>Joined</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($recent_users as $user): ?>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="user-avatar me-3">
                                            <?php echo strtoupper(substr($user['full_name'], 0, 1)); ?>
                                        </div>
                                        <div>
                                            <strong><?php echo htmlspecialchars($user['full_name']); ?></strong>
                                        </div>
                                    </div>
                                </td>
                                <td><?php echo htmlspecialchars($user['email']); ?></td>
                                <td>
                                        <span class="badge bg-<?php echo $user['subscription_type'] == 'premium' ? 'warning text-dark' : 'secondary'; ?>">
                                            <?php echo ucfirst($user['subscription_type']); ?>
                                        </span>
                                </td>
                                <td><?php echo date('M d, Y', strtotime($user['created_at'])); ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="admin-card">
                <h5 class="mb-4">Quick Actions</h5>
                <div class="row g-3">
                    <div class="col-6">
                        <a href="users.php?action=add" class="btn btn-primary w-100 text-start">
                            <i class="fas fa-user-plus me-2"></i> Add User
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="reports.php" class="btn btn-success w-100 text-start">
                            <i class="fas fa-download me-2"></i> Generate Report
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="settings.php" class="btn btn-info w-100 text-start">
                            <i class="fas fa-cog me-2"></i> System Settings
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="backup.php" class="btn btn-warning w-100 text-start">
                            <i class="fas fa-database me-2"></i> Backup Database
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="logs.php" class="btn btn-dark w-100 text-start">
                            <i class="fas fa-file-alt me-2"></i> View Logs
                        </a>
                    </div>
                    <div class="col-6">
                        <button class="btn btn-danger w-100 text-start" onclick="clearCache()">
                            <i class="fas fa-trash-alt me-2"></i> Clear Cache
                        </button>
                    </div>
                </div>

                <div class="mt-4">
                    <h6>System Status</h6>
                    <div class="mt-3">
                        <div class="d-flex justify-content-between mb-2">
                            <span>CPU Usage</span>
                            <span class="text-success">45%</span>
                        </div>
                        <div class="progress mb-3">
                            <div class="progress-bar bg-success" style="width: 45%"></div>
                        </div>

                        <div class="d-flex justify-content-between mb-2">
                            <span>Memory Usage</span>
                            <span class="text-warning">68%</span>
                        </div>
                        <div class="progress mb-3">
                            <div class="progress-bar bg-warning" style="width: 68%"></div>
                        </div>

                        <div class="d-flex justify-content-between mb-2">
                            <span>Disk Space</span>
                            <span class="text-info">32%</span>
                        </div>
                        <div class="progress">
                            <div class="progress-bar bg-info" style="width: 32%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Activity Chart
    const activityCtx = document.getElementById('activityChart').getContext('2d');
    const activityChart = new Chart(activityCtx, {
        type: 'line',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
            datasets: [{
                label: 'QR Codes Generated',
                data: [1200, 1900, 1500, 2500, 2200, 3000, 2800, 3500, 3000, 4000, 3800, 4500],
                borderColor: '#4a6fa5',
                backgroundColor: 'rgba(74, 111, 165, 0.1)',
                fill: true,
                tension: 0.4
            }, {
                label: 'QR Code Scans',
                data: [5000, 7000, 6500, 8000, 7500, 9000, 8500, 10000, 9500, 11000, 10500, 12000],
                borderColor: '#4fc3a1',
                backgroundColor: 'rgba(79, 195, 161, 0.1)',
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // User Chart
    const userCtx = document.getElementById('userChart').getContext('2d');
    const userChart = new Chart(userCtx, {
        type: 'doughnut',
        data: {
            labels: ['Free Users', 'Premium Users', 'Enterprise Users'],
            datasets: [{
                data: [75, 20, 5],
                backgroundColor: [
                    '#4a6fa5',
                    '#4fc3a1',
                    '#ff6b6b'
                ]
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom',
                }
            }
        }
    });

    function clearCache() {
        if (confirm('Are you sure you want to clear all cache?')) {
            fetch('<?php echo SITE_URL; ?>api/v1/admin/clear-cache', {
                method: 'POST',
                headers: {
                    'Authorization': 'Bearer <?php echo $user['api_key']; ?>'
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert('Cache cleared successfully');
                    } else {
                        alert('Error: ' + data.error);
                    }
                })
                .catch(error => {
                    alert('An error occurred');
                });
        }
    }
</script>
</body>
</html>