<?php
require_once __DIR__ . '/../../app/middleware/Auth.php';
$auth = new Auth();
$user = $auth->requireAdmin();

require_once __DIR__ . '/../../app/models/Analytics.php';
$analyticsModel = new Analytics();

// Get date range from query parameters
$start_date = $_GET['start_date'] ?? date('Y-m-01');
$end_date = $_GET['end_date'] ?? date('Y-m-d');

// Get analytics data
$daily_stats = $analyticsModel->getDailyStats($start_date, $end_date);
$top_qr_codes = $analyticsModel->getTopQRCodes(10);
$device_stats = $analyticsModel->getDeviceStats($start_date, $end_date);
$country_stats = $analyticsModel->getCountryStats($start_date, $end_date);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Analytics Dashboard - Admin - <?php echo SITE_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chartjs-adapter-date-fns"></script>
    <style>
        body {
            background-color: #f5f7fa;
        }

        .sidebar {
            background: #2d3e50;
            color: white;
            min-height: 100vh;
            position: fixed;
            width: 250px;
        }

        .main-content {
            margin-left: 250px;
            padding: 20px;
        }

        .sidebar .nav-link {
            color: #adb5bd;
            padding: 12px 20px;
            border-left: 3px solid transparent;
            transition: all 0.3s;
        }

        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
            border-left-color: #4fc3a1;
        }

        .analytics-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            margin-bottom: 20px;
        }

        .stat-card {
            text-align: center;
            padding: 20px;
        }

        .stat-number {
            font-size: 2rem;
            font-weight: bold;
            color: #4a6fa5;
            line-height: 1;
        }

        .stat-label {
            color: #6c757d;
            font-size: 0.9rem;
            margin-top: 5px;
        }

        .date-filter {
            background: white;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
<!-- Sidebar -->
<div class="sidebar">
    <div class="p-4">
        <h4 class="mb-4">
            <i class="fas fa-qrcode me-2"></i><?php echo SITE_NAME; ?>
            <span class="badge bg-danger ms-2">Admin</span>
        </h4>

        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link" href="dashboard.php">
                    <i class="fas fa-tachometer-alt me-2"></i> Dashboard
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="users.php">
                    <i class="fas fa-users me-2"></i> Users
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="qr-codes.php">
                    <i class="fas fa-qrcode me-2"></i> QR Codes
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link active" href="analytics.php">
                    <i class="fas fa-chart-line me-2"></i> Analytics
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="templates.php">
                    <i class="fas fa-palette me-2"></i> Templates
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="settings.php">
                    <i class="fas fa-cog me-2"></i> Settings
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="reports.php">
                    <i class="fas fa-file-alt me-2"></i> Reports
                </a>
            </li>
            <li class="nav-item mt-4">
                <a class="nav-link text-danger" href="<?php echo SITE_URL; ?>logout.php">
                    <i class="fas fa-sign-out-alt me-2"></i> Logout
                </a>
            </li>
        </ul>
    </div>
</div>

<!-- Main Content -->
<div class="main-content">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Analytics Dashboard</h1>
        <div>
            <span class="me-3">Data from <?php echo date('M d, Y', strtotime($start_date)); ?> to <?php echo date('M d, Y', strtotime($end_date)); ?></span>
            <a href="analytics.php?export=csv&start_date=<?php echo $start_date; ?>&end_date=<?php echo $end_date; ?>"
               class="btn btn-success">
                <i class="fas fa-download me-2"></i> Export CSV
            </a>
        </div>
    </div>

    <!-- Date Filter -->
    <div class="date-filter">
        <form method="GET" class="row g-3">
            <div class="col-md-3">
                <label for="start_date" class="form-label">Start Date</label>
                <input type="date" class="form-control" id="start_date" name="start_date"
                       value="<?php echo $start_date; ?>" max="<?php echo date('Y-m-d'); ?>">
            </div>
            <div class="col-md-3">
                <label for="end_date" class="form-label">End Date</label>
                <input type="date" class="form-control" id="end_date" name="end_date"
                       value="<?php echo $end_date; ?>" max="<?php echo date('Y-m-d'); ?>">
            </div>
            <div class="col-md-2">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-primary w-100">
                    <i class="fas fa-filter me-2"></i> Apply Filter
                </button>
            </div>
            <div class="col-md-2">
                <label class="form-label">&nbsp;</label>
                <a href="analytics.php" class="btn btn-outline-secondary w-100">
                    <i class="fas fa-redo me-2"></i> Reset
                </a>
            </div>
            <div class="col-md-2">
                <label class="form-label">Quick Select</label>
                <div class="btn-group w-100">
                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="setDateRange('today')">Today</button>
                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="setDateRange('week')">Week</button>
                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="setDateRange('month')">Month</button>
                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="setDateRange('year')">Year</button>
                </div>
            </div>
        </form>
    </div>

    <!-- Summary Stats -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="analytics-card stat-card">
                <div class="stat-number">
                    <?php echo number_format(array_sum(array_column($daily_stats, 'scans'))); ?>
                </div>
                <div class="stat-label">Total Scans</div>
                <div class="mt-3">
                    <span class="badge bg-success">+12% vs previous period</span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="analytics-card stat-card">
                <div class="stat-number">
                    <?php echo number_format(count($daily_stats)); ?>
                </div>
                <div class="stat-label">Active Days</div>
                <div class="mt-3">
                    <span class="badge bg-info">Daily average: <?php echo number_format(array_sum(array_column($daily_stats, 'scans')) / max(1, count($daily_stats))); ?></span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="analytics-card stat-card">
                <div class="stat-number">
                    <?php echo number_format(count($top_qr_codes)); ?>
                </div>
                <div class="stat-label">Active QR Codes</div>
                <div class="mt-3">
                    <span class="badge bg-warning">Top QR: <?php echo $top_qr_codes[0]['scans'] ?? 0; ?> scans</span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="analytics-card stat-card">
                <div class="stat-number">
                    <?php echo count($country_stats); ?>
                </div>
                <div class="stat-label">Countries</div>
                <div class="mt-3">
                    <span class="badge bg-primary">Top: <?php echo $country_stats[0]['country'] ?? 'N/A'; ?></span>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts -->
    <div class="row mb-4">
        <div class="col-md-8">
            <div class="analytics-card">
                <h5 class="mb-4">Daily Scan Activity</h5>
                <canvas id="dailyChart" height="250"></canvas>
            </div>
        </div>
        <div class="col-md-4">
            <div class="analytics-card">
                <h5 class="mb-4">Device Distribution</h5>
                <canvas id="deviceChart" height="250"></canvas>
            </div>
        </div>
    </div>

    <!-- Top QR Codes -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="analytics-card">
                <h5 class="mb-4">Top Performing QR Codes</h5>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                        <tr>
                            <th>QR Code</th>
                            <th>Type</th>
                            <th>Scans</th>
                            <th>User</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($top_qr_codes as $qr): ?>
                            <tr>
                                <td>
                                    <strong><?php echo htmlspecialchars($qr['title']); ?></strong><br>
                                    <small class="text-muted">ID: <?php echo $qr['public_id']; ?></small>
                                </td>
                                <td>
                                        <span class="badge bg-<?php echo $qr['is_dynamic'] ? 'info' : 'secondary'; ?>">
                                            <?php echo $qr['is_dynamic'] ? 'Dynamic' : 'Static'; ?>
                                        </span>
                                </td>
                                <td>
                                    <strong><?php echo number_format($qr['scans']); ?></strong>
                                </td>
                                <td>
                                    <?php echo htmlspecialchars($qr['user_email']); ?>
                                </td>
                                <td>
                                    <a href="qr-details.php?id=<?php echo $qr['public_id']; ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="analytics-card">
                <h5 class="mb-4">Geographic Distribution</h5>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                        <tr>
                            <th>Country</th>
                            <th>Scans</th>
                            <th>Percentage</th>
                            <th>Trend</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        $total_country_scans = array_sum(array_column($country_stats, 'scans'));
                        foreach ($country_stats as $country):
                            $percentage = $total_country_scans > 0 ? ($country['scans'] / $total_country_scans * 100) : 0;
                            ?>
                            <tr>
                                <td>
                                    <i class="fas fa-globe me-2"></i>
                                    <?php echo $country['country'] ?: 'Unknown'; ?>
                                </td>
                                <td><?php echo number_format($country['scans']); ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="progress flex-grow-1 me-2" style="height: 6px;">
                                            <div class="progress-bar bg-success" style="width: <?php echo $percentage; ?>%"></div>
                                        </div>
                                        <span><?php echo round($percentage, 1); ?>%</span>
                                    </div>
                                </td>
                                <td>
                                        <span class="badge bg-<?php echo $country['trend'] > 0 ? 'success' : ($country['trend'] < 0 ? 'danger' : 'secondary'); ?>">
                                            <i class="fas fa-arrow-<?php echo $country['trend'] > 0 ? 'up' : ($country['trend'] < 0 ? 'down' : 'right'); ?>"></i>
                                            <?php echo abs($country['trend']); ?>%
                                        </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Hourly Distribution -->
    <div class="row">
        <div class="col-12">
            <div class="analytics-card">
                <h5 class="mb-4">Hourly Scan Distribution</h5>
                <canvas id="hourlyChart" height="150"></canvas>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Set date range
    function setDateRange(range) {
        const today = new Date();
        let startDate, endDate;

        switch(range) {
            case 'today':
                startDate = today.toISOString().split('T')[0];
                endDate = startDate;
                break;
            case 'week':
                startDate = new Date(today.setDate(today.getDate() - 7)).toISOString().split('T')[0];
                endDate = new Date().toISOString().split('T')[0];
                break;
            case 'month':
                startDate = new Date(today.getFullYear(), today.getMonth(), 1).toISOString().split('T')[0];
                endDate = new Date().toISOString().split('T')[0];
                break;
            case 'year':
                startDate = new Date(today.getFullYear(), 0, 1).toISOString().split('T')[0];
                endDate = new Date().toISOString().split('T')[0];
                break;
        }

        document.getElementById('start_date').value = startDate;
        document.getElementById('end_date').value = endDate;
        document.querySelector('form').submit();
    }

    // Daily Chart
    const dailyCtx = document.getElementById('dailyChart').getContext('2d');
    const dailyChart = new Chart(dailyCtx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode(array_column($daily_stats, 'date')); ?>,
            datasets: [{
                label: 'Scans',
                data: <?php echo json_encode(array_column($daily_stats, 'scans')); ?>,
                backgroundColor: '#4a6fa5',
                borderColor: '#4a6fa5',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        precision: 0
                    }
                }
            }
        }
    });

    // Device Chart
    const deviceCtx = document.getElementById('deviceChart').getContext('2d');
    const deviceChart = new Chart(deviceCtx, {
        type: 'pie',
        data: {
            labels: <?php echo json_encode(array_column($device_stats, 'device_type')); ?>,
            datasets: [{
                data: <?php echo json_encode(array_column($device_stats, 'scans')); ?>,
                backgroundColor: [
                    '#4a6fa5',
                    '#4fc3a1',
                    '#ff6b6b',
                    '#ffa726'
                ]
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom',
                }
            }
        }
    });

    // Hourly Chart
    const hourlyCtx = document.getElementById('hourlyChart').getContext('2d');
    const hourlyChart = new Chart(hourlyCtx, {
        type: 'line',
        data: {
            labels: Array.from({length: 24}, (_, i) => `${i}:00`),
            datasets: [{
                label: 'Average Scans per Hour',
                data: <?php echo json_encode(array_fill(0, 24, 0)); ?>, // Replace with actual data
                borderColor: '#4fc3a1',
                backgroundColor: 'rgba(79, 195, 161, 0.1)',
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
</body>
</html>