<?php
// Start session
session_start();

// Load configuration
require_once __DIR__ . '/app/config/constants.php';
require_once __DIR__ . '/app/config/database.php';

// Get requested page
$page = $_GET['page'] ?? 'home';
$action = $_GET['action'] ?? '';

// Route the request
switch ($page) {
    case 'home':
        require_once __DIR__ . '/templates/frontend/home.php';
        break;

    case 'generator':
        require_once __DIR__ . '/templates/frontend/generator.php';
        break;

    case 'templates':
        require_once __DIR__ . '/templates/frontend/templates.php';
        break;

    case 'pricing':
        require_once __DIR__ . '/templates/frontend/pricing.php';
        break;

    case 'features':
        require_once __DIR__ . '/templates/frontend/features.php';
        break;

    case 'dashboard':
        require_once __DIR__ . '/templates/frontend/dashboard.php';
        break;

    case 'my-qrcodes':
        require_once __DIR__ . '/templates/frontend/my-qrcodes.php';
        break;

    case 'analytics':
        require_once __DIR__ . '/templates/frontend/analytics.php';
        break;

    case 'settings':
        require_once __DIR__ . '/templates/frontend/settings.php';
        break;

    case 'login':
        require_once __DIR__ . '/templates/frontend/login.php';
        break;

    case 'register':
        require_once __DIR__ . '/templates/frontend/register.php';
        break;

    case 'logout':
        require_once __DIR__ . '/app/controllers/UserController.php';
        $controller = new UserController();
        $controller->logout();
        break;

    case 'scan':
        require_once __DIR__ . '/app/controllers/QrController.php';
        $controller = new QrController();
        $controller->scan($_GET['id'] ?? '');
        break;

    case 'edit-qr':
        require_once __DIR__ . '/templates/frontend/edit-qr.php';
        break;

    case 'qr-analytics':
        require_once __DIR__ . '/templates/frontend/qr-analytics.php';
        break;

    // Admin pages
    case 'admin-dashboard':
        require_once __DIR__ . '/templates/admin/dashboard.php';
        break;

    case 'admin-analytics':
        require_once __DIR__ . '/templates/admin/analytics.php';
        break;

    case 'admin-users':
        require_once __DIR__ . '/templates/admin/users.php';
        break;

    case 'admin-qr-codes':
        require_once __DIR__ . '/templates/admin/qr-codes.php';
        break;

    case 'admin-settings':
        require_once __DIR__ . '/templates/admin/settings.php';
        break;

    // API routes
    case 'api':
        $api_version = $_GET['version'] ?? 'v1';
        $endpoint = $_GET['endpoint'] ?? '';
        $method = $_SERVER['REQUEST_METHOD'];

        // Route to appropriate API endpoint
        if ($api_version === 'v1') {
            if (strpos($endpoint, 'qr/') === 0) {
                require_once __DIR__ . '/api/v1/qr.php';
            } elseif (strpos($endpoint, 'user/') === 0) {
                require_once __DIR__ . '/api/v1/user.php';
            } elseif (strpos($endpoint, 'analytics/') === 0) {
                require_once __DIR__ . '/api/v1/analytics.php';
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'API endpoint not found']);
            }
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'API version not supported']);
        }
        break;

    // Error pages
    case '404':
        http_response_code(404);
        require_once __DIR__ . '/templates/errors/404.php';
        break;

    case '403':
        http_response_code(403);
        require_once __DIR__ . '/templates/errors/403.php';
        break;

    case '500':
        http_response_code(500);
        require_once __DIR__ . '/templates/errors/500.php';
        break;

    default:
        // Check if it's a direct file request
        $file_path = __DIR__ . '/' . $page;
        if (file_exists($file_path) && is_file($file_path)) {
            require_once $file_path;
        } else {
            // 404 Not Found
            http_response_code(404);
            require_once __DIR__ . '/templates/errors/404.php';
        }
}

// Handle post-processing
if (isset($_SESSION['flash_messages'])) {
    unset($_SESSION['flash_messages']);
}
?>