<?php
require_once __DIR__ . '/../models/User.php';

class Auth {

    public function authenticate() {
        // Check session first
        session_start();
        if (isset($_SESSION['user_id'])) {
            $userModel = new User();
            return $userModel->findById($_SESSION['user_id']);
        }

        // Check API key in headers
        $headers = getallheaders();
        $api_key = $headers['Authorization'] ?? $headers['authorization'] ?? '';
        $api_key = str_replace('Bearer ', '', $api_key);

        if (!empty($api_key)) {
            $userModel = new User();
            return $userModel->findByApiKey($api_key);
        }

        // Check API key in query parameter
        $api_key = $_GET['api_key'] ?? '';
        if (!empty($api_key)) {
            $userModel = new User();
            return $userModel->findByApiKey($api_key);
        }

        return false;
    }

    public function requireAuth() {
        $user = $this->authenticate();

        if (!$user) {
            http_response_code(401);
            echo json_encode(['error' => 'Authentication required']);
            exit();
        }

        return $user;
    }

    public function requireAdmin() {
        $user = $this->requireAuth();

        if ($user['role'] !== 'admin') {
            http_response_code(403);
            echo json_encode(['error' => 'Admin access required']);
            exit();
        }

        return $user;
    }

    public function checkOwnership($qr_user_id) {
        $user = $this->authenticate();

        if (!$user) {
            return false;
        }

        return $user['id'] == $qr_user_id;
    }

    public function getCurrentUser() {
        return $this->authenticate();
    }

    public function login($email, $password) {
        $userModel = new User();
        $user = $userModel->authenticate($email, $password);

        if ($user) {
            session_start();
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_email'] = $user['email'];
            $_SESSION['user_name'] = $user['full_name'];

            // Regenerate session ID for security
            session_regenerate_id(true);

            return $user;
        }

        return false;
    }

    public function logout(): bool
    {
        session_start();
        session_destroy();
        return true;
    }

    public function isLoggedIn(): bool
    {
        return isset($_SESSION['user_id']);
    }

    public function getUserId() {
        session_start();
        return $_SESSION['user_id'] ?? null;
    }

    public function getUserEmail() {
        session_start();
        return $_SESSION['user_email'] ?? null;
    }

    public function getUserName() {
        session_start();
        return $_SESSION['user_name'] ?? null;
    }
}
?>