<?php
// Database Configuration
const DB_HOST = 'localhost';
const DB_NAME = 'imqsvuod_qr_wala_guru';
const DB_USER = 'imqsvuod_master';
const DB_PASS = 'Dear@601';
const BASE_URL = 'https://qr.wala.guru/'; // adjust to your domain

// Application Configuration
define('SITE_URL', 'https://qr.wala.guru/');
define('SITE_NAME', 'QR Wala Guru');
define('SITE_TAGLINE', 'Free QR Code Generator');

// Path Configuration
define('BASE_PATH', dirname(__DIR__, 2) . '/');
define('UPLOAD_PATH', BASE_PATH . 'uploads/');
define('LOGO_PATH', UPLOAD_PATH . 'logos/');
define('QRCODE_PATH', UPLOAD_PATH . 'qrcodes/');
define('ASSETS_URL', SITE_URL . 'assets/');

// QR Code Settings
define('QR_DEFAULT_SIZE', 300);
define('QR_MAX_SIZE', 2000);
define('QR_MIN_SIZE', 100);
define('QR_DEFAULT_MARGIN', 10);
define('QR_DEFAULT_COLOR_FG', '#000000');
define('QR_DEFAULT_COLOR_BG', '#FFFFFF');
define('QR_DEFAULT_ERROR_CORRECTION', 'H'); // L, M, Q, H

// File Upload Settings
define('MAX_FILE_SIZE', 5242880); // 5MB
define('ALLOWED_IMAGE_TYPES', ['jpg', 'jpeg', 'png', 'gif', 'svg']);
define('MAX_QR_PER_USER_FREE', 50);
define('MAX_QR_PER_USER_PREMIUM', 1000);

// Security
define('SESSION_TIMEOUT', 3600); // 1 hour
define('API_RATE_LIMIT', 100); // requests per hour
define('ENCRYPTION_KEY', 'your-secure-key-here');

// Development
define('DEBUG_MODE', true);
define('LOG_PATH', BASE_PATH . 'logs/');

// Email Configuration
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USER', '');
define('SMTP_PASS', '');
define('FROM_EMAIL', 'noreply@qrstuff.com');
define('FROM_NAME', 'QRStuff Clone');

// Set timezone
date_default_timezone_set('UTC');

// Error reporting
if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Create necessary directories if they don't exist
if (!file_exists(LOG_PATH)) mkdir(LOG_PATH, 0755, true);
if (!file_exists(LOGO_PATH)) mkdir(LOGO_PATH, 0755, true);
if (!file_exists(QRCODE_PATH)) mkdir(QRCODE_PATH, 0755, true);
?>