<?php
require_once __DIR__ . '/../../app/config/cors.php';
require_once __DIR__ . '/../../app/controllers/UserController.php';

$method = $_SERVER['REQUEST_METHOD'];
$path = $_SERVER['PATH_INFO'] ?? '';

// Extract action from URL
preg_match('/\/([a-zA-Z]+)/', $path, $matches);
$action = $matches[1] ?? '';

$controller = new UserController();

switch ($method) {
    case 'GET':
        if ($action === 'profile') {
            $controller->profile();
        } elseif ($action === 'stats') {
            $controller->stats();
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Endpoint not found']);
        }
        break;

    case 'POST':
        if ($action === 'register') {
            $controller->register();
        } elseif ($action === 'login') {
            $controller->login();
        } elseif ($action === 'logout') {
            $controller->logout();
        } elseif ($action === 'change-password') {
            $controller->changePassword();
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Endpoint not found']);
        }
        break;

    case 'PUT':
        if ($action === 'update') {
            $controller->update();
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Endpoint not found']);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
}
?>