<?php
require_once __DIR__ . '/../../app/config/cors.php';
require_once __DIR__ . '/../../app/controllers/QrController.php';

$method = $_SERVER['REQUEST_METHOD'];
$path = $_SERVER['PATH_INFO'] ?? '';

// Extract public ID from URL
preg_match('/\/([a-zA-Z0-9]+)(?:\/([a-zA-Z]+))?/', $path, $matches);
$public_id = $matches[1] ?? null;
$action = $matches[2] ?? '';

$controller = new QrController();

switch ($method) {
    case 'GET':
        if ($public_id) {
            if ($action === 'download') {
                $controller->download($public_id);
            } elseif ($action === 'analytics') {
                require_once __DIR__ . '/../../app/controllers/AnalyticsController.php';
                $analyticsController = new AnalyticsController();
                $analyticsController->getQRCodeAnalytics($public_id);
            } else {
                $controller->get($public_id);
            }
        } else {
            $controller->list();
        }
        break;

    case 'POST':
        if ($public_id && $action === 'scan') {
            $controller->scan($public_id);
        } else {
            $controller->generate();
        }
        break;

    case 'PUT':
        if ($public_id) {
            $controller->update($public_id);
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'QR code ID required']);
        }
        break;

    case 'DELETE':
        if ($public_id) {
            $controller->delete($public_id);
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'QR code ID required']);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
}
?>