<?php
require_once __DIR__ . '/../../app/config/cors.php';
require_once __DIR__ . '/../../app/controllers/AnalyticsController.php';
require_once __DIR__ . '/../../app/middleware/RateLimit.php';

// Apply rate limiting
RateLimit::apply('ip', 100, 3600); // 100 requests per hour per IP

$method = $_SERVER['REQUEST_METHOD'];
$path = $_SERVER['PATH_INFO'] ?? $_SERVER['REQUEST_URI'] ?? '';
$path = str_replace('/api/v1/analytics', '', $path);

// Extract QR code ID from URL
preg_match('/\/([a-zA-Z0-9]+)(?:\/([a-zA-Z]+))?/', $path, $matches);
$public_id = $matches[1] ?? null;
$action = $matches[2] ?? '';

$controller = new AnalyticsController();

try {
    switch ($method) {
        case 'GET':
            if ($public_id) {
                if ($action === 'export') {
                    $controller->exportQRCodeAnalytics($public_id);
                } else {
                    $controller->getQRCodeAnalytics($public_id);
                }
            } else {
                // Check if it's real-time analytics
                if (isset($_GET['realtime']) && $_GET['realtime'] === 'true') {
                    $controller->getRealTimeAnalytics();
                } else {
                    $controller->getUserAnalytics();
                }
            }
            break;

        case 'POST':
            // Log a scan (typically called when QR code is scanned)
            if ($public_id && $action === 'scan') {
                // This would be called from the scan endpoint, not directly
                http_response_code(404);
                echo json_encode(['error' => 'Use /api/v1/qr/{id}/scan to log scans']);
            } else {
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed for this endpoint']);
            }
            break;

        default:
            http_response_code(405);
            echo json_encode(['error' => 'Method not allowed']);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Internal server error',
        'message' => DEBUG_MODE ? $e->getMessage() : 'An error occurred'
    ]);

    // Log the error
    error_log("Analytics API Error: " . $e->getMessage() . "\n" . $e->getTraceAsString());
}
?>