<?php
if (!function_exists('ui_input')) {
    /**
     * Renders a UI Input.
     * 
     * @param string $name Input name attribute
     * @param array $options Configuration options (type, value, placeholder, class, required, attributes)
     * @return string HTML output
     */
    function ui_input($name, $options = []) {
        $type = $options['type'] ?? 'text';
        $value = $options['value'] ?? '';
        $placeholder = $options['placeholder'] ?? '';
        $class = $options['class'] ?? '';
        $required = !empty($options['required']) ? 'required' : '';
        $attributes = $options['attributes'] ?? '';

        $base_class = 'block w-full px-3 py-2 border border-border rounded-md text-sm focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary bg-white';
        $final_class = trim("$base_class $class");

        return sprintf(
            '<input type="%s" name="%s" value="%s" placeholder="%s" class="%s" %s %s/>',
            htmlspecialchars($type, ENT_QUOTES),
            htmlspecialchars($name, ENT_QUOTES),
            htmlspecialchars((string)$value, ENT_QUOTES),
            htmlspecialchars($placeholder, ENT_QUOTES),
            htmlspecialchars($final_class, ENT_QUOTES),
            $required,
            $attributes
        );
    }
}
?>