<?php
if (!function_exists('ui_card')) {
    /**
     * Renders a UI Card.
     * 
     * @param array $options Configuration options (title, body, footer, class)
     * @return string HTML output
     */
    function ui_card($options = []) {
        $title = $options['title'] ?? null;
        $body = $options['body'] ?? '';
        $footer = $options['footer'] ?? null;
        $class = $options['class'] ?? '';

        $html = sprintf('<div class="bg-surface border border-border rounded-lg shadow-sm %s">', htmlspecialchars($class, ENT_QUOTES));
        
        if ($title) {
            $html .= '<div class="px-5 py-4 border-b border-border"><h3 class="font-semibold text-text-main m-0">' . $title . '</h3></div>';
        }
        
        $html .= '<div class="p-5">' . $body . '</div>';
        
        if ($footer) {
            $html .= '<div class="p-4 bg-gray-50 border-t border-border rounded-b-lg">' . $footer . '</div>';
        }
        
        $html .= '</div>';

        return $html;
    }
}
?>