<?php
if (!function_exists('ui_button')) {
    /**
     * Renders a UI Button.
     * 
     * @param string $label Button text or HTML (e.g., icons)
     * @param array $options Configuration options (type, variant, class, attributes)
     * @return string HTML output
     */
    function ui_button($label, $options = []) {
        $type = $options['type'] ?? 'button';
        $variant = $options['variant'] ?? 'primary';
        $class = $options['class'] ?? '';
        $attributes = $options['attributes'] ?? ''; // e.g., 'onclick="..."' or 'disabled'

        $base_class = 'px-4 py-2 text-sm font-medium rounded transition-colors inline-flex items-center justify-center';
        
        $variants = [
            'primary'   => 'bg-primary text-white hover:bg-primary-hover border border-transparent',
            'secondary' => 'bg-white text-text-main border border-border hover:bg-gray-50',
            'danger'    => 'bg-red-500 text-white hover:bg-red-600 border border-transparent',
            'ghost'     => 'bg-transparent text-primary hover:bg-gray-100 border border-transparent'
        ];

        $selected_variant = $variants[$variant] ?? $variants['primary'];
        $final_class = trim("$base_class $selected_variant $class");

        return sprintf(
            '<button type="%s" class="%s" %s>%s</button>',
            htmlspecialchars($type, ENT_QUOTES),
            htmlspecialchars($final_class, ENT_QUOTES),
            $attributes,
            $label // Outputting raw to allow HTML like SVGs inside the button
        );
    }
}
?>