<?php
if (!function_exists('ui_badge')) {
    /**
     * Renders a UI Badge.
     * 
     * @param string $label The text inside the badge
     * @param string $variant 'default', 'success', 'warning', 'danger', 'primary'
     * @param string $additional_classes Extra Tailwind classes
     * @return string HTML output
     */
    function ui_badge($label, $variant = 'default', $additional_classes = '') {
        $base_classes = 'inline-flex items-center px-2 py-0.5 rounded text-xs font-medium border';
        
        $variant_classes = [
            'default' => 'bg-gray-100 text-gray-800 border-gray-200',
            'success' => 'bg-green-100 text-green-800 border-green-200',
            'warning' => 'bg-yellow-100 text-yellow-800 border-yellow-200',
            'danger'  => 'bg-red-100 text-red-800 border-red-200',
            'primary' => 'bg-blue-100 text-blue-800 border-blue-200'
        ];

        $selected_variant = $variant_classes[$variant] ?? $variant_classes['default'];
        $classes = trim("$base_classes $selected_variant $additional_classes");

        return sprintf(
            '<span class="%s">%s</span>',
            htmlspecialchars($classes, ENT_QUOTES),
            htmlspecialchars($label, ENT_QUOTES)
        );
    }
}
?>