<?php
require_once '../config.php';
include '../includes/header.php';
?>
<div class="space-y-6">
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-text-main">WooCommerce Home</h2>
        </div>
    </div>
    
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <?= ui_card(['body' => '<div class="text-text-muted mb-1">Total Sales</div><div class="text-2xl font-bold">$12,450.00</div><div class="text-green-500 text-sm mt-2">+15% from last month</div>']) ?>
        <?= ui_card(['body' => '<div class="text-text-muted mb-1">Orders</div><div class="text-2xl font-bold">142</div><div class="text-green-500 text-sm mt-2">+5% from last month</div>']) ?>
        <?= ui_card(['body' => '<div class="text-text-muted mb-1">New Customers</div><div class="text-2xl font-bold">45</div><div class="text-red-500 text-sm mt-2">-2% from last month</div>']) ?>
    </div>

    <?= ui_card([
        'title' => 'Recent Orders',
        'body' => '<table class="w-full text-sm text-left">
            <thead class="border-b text-text-muted">
                <tr><th class="py-2">Order</th><th class="py-2">Date</th><th class="py-2">Status</th><th class="py-2 text-right">Total</th></tr>
            </thead>
            <tbody class="divide-y">
                <tr><td class="py-3 text-primary font-medium">#1042 John Doe</td><td class="py-3 text-text-muted">2 mins ago</td><td class="py-3">'.ui_badge('Processing', 'warning').'</td><td class="py-3 text-right">$120.00</td></tr>
                <tr><td class="py-3 text-primary font-medium">#1041 Jane Smith</td><td class="py-3 text-text-muted">1 hour ago</td><td class="py-3">'.ui_badge('Completed', 'success').'</td><td class="py-3 text-right">$45.50</td></tr>
                <tr><td class="py-3 text-primary font-medium">#1040 Bob Johnson</td><td class="py-3 text-text-muted">Yesterday</td><td class="py-3">'.ui_badge('On Hold', 'default').'</td><td class="py-3 text-right">$399.00</td></tr>
            </tbody>
        </table>'
    ]) ?>
</div>
<?php include '../includes/footer.php'; ?>