<?php
require_once '../config.php';

// Handle user deletion
if (isset($_POST['delete_id'])) {
    $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
    $stmt->execute([$_POST['delete_id']]);
    header("Location: UsersList.php?msg=deleted");
    exit;
}

// Fetch Users
$stmt = $pdo->query("SELECT * FROM users ORDER BY created_at DESC");
$users = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="space-y-6">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-text-main">Users</h2>
            <p class="text-sm text-text-muted mt-1">Manage system users and their roles.</p>
        </div>
        <div class="flex space-x-2">
            <button class="bg-primary text-white hover:bg-primary-hover px-4 py-2 text-sm font-medium rounded transition-colors inline-flex items-center">
                <svg class="mr-2" width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
                Add User
            </button>
        </div>
    </div>

    <?php if(isset($_GET['msg']) && $_GET['msg'] == 'deleted'): ?>
        <div class="bg-green-100 text-green-800 p-3 rounded text-sm border border-green-200">User deleted successfully.</div>
    <?php endif; ?>

    <div class="bg-surface border border-border rounded-lg shadow-sm">
        <div class="p-4 border-b border-border flex flex-col sm:flex-row justify-between gap-4">
            <div class="relative w-full sm:w-72">
                <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-text-muted">
                    <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>
                </span>
                <input type="text" placeholder="Search users..." class="block w-full pl-10 pr-3 py-2 border border-border rounded-md text-sm focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary" />
            </div>
        </div>

        <div class="overflow-x-auto">
            <table class="w-full text-sm text-left whitespace-nowrap">
                <thead class="text-xs text-text-muted uppercase bg-gray-50/50 border-b border-border">
                    <tr>
                        <th class="px-6 py-3 font-medium">User</th>
                        <th class="px-6 py-3 font-medium">Email</th>
                        <th class="px-6 py-3 font-medium">Role</th>
                        <th class="px-6 py-3 font-medium">Status</th>
                        <th class="px-6 py-3 font-medium text-right">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-border">
                    <?php if(count($users) > 0): ?>
                        <?php foreach($users as $user): ?>
                        <tr class="hover:bg-gray-50/50 transition-colors">
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded bg-primary/10 text-primary flex items-center justify-center font-bold border border-primary/20">
                                        <?= strtoupper(substr(escape($user['name']), 0, 1)) ?>
                                    </div>
                                    <div class="font-medium text-text-main"><?= escape($user['name']) ?></div>
                                </div>
                            </td>
                            <td class="px-6 py-4 text-text-muted"><?= escape($user['email']) ?></td>
                            <td class="px-6 py-4"><span class="text-text-main"><?= escape($user['role']) ?></span></td>
                            <td class="px-6 py-4">
                                <?php if($user['status'] == 'Active'): ?>
                                    <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium border bg-green-100 text-green-800 border-green-200">Active</span>
                                <?php else: ?>
                                    <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium border bg-gray-100 text-gray-800 border-gray-200">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <form action="UsersList.php" method="POST" class="inline" onsubmit="return confirm('Delete this user?');">
                                    <input type="hidden" name="delete_id" value="<?= $user['id'] ?>">
                                    <button type="submit" class="text-red-500 hover:text-red-700 hover:bg-red-50 p-1 rounded">
                                        <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path></svg>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="5" class="px-6 py-10 text-center text-text-muted">No users found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>