<?php
require_once '../config.php';
include '../includes/header.php';
?>

<div class="space-y-6 max-w-4xl">
  <div>
    <h2 class="text-2xl font-bold text-text-main">WordPress Updates</h2>
    <p class="text-sm text-text-muted mt-1">Last checked on October 25, 2023 at 10:45 am. <button class="text-primary hover:underline bg-transparent border-none p-0 cursor-pointer">Check again</button>.</p>
  </div>

  <div class="bg-surface border border-border rounded-lg shadow-sm p-5">
      <div class="space-y-4">
          <h3 class="font-semibold text-text-main text-lg">Current Version</h3>
          <p class="text-sm">You have the latest version of WordPress (Clone Edition).</p>
          <button class="bg-white text-text-main border border-border hover:bg-gray-50 px-4 py-2 text-sm font-medium rounded transition-colors">Re-install version 6.3.2</button>
      </div>
  </div>

  <div class="bg-surface border border-border rounded-lg shadow-sm p-5">
      <div class="space-y-4">
          <h3 class="font-semibold text-text-main text-lg">Plugins</h3>
          <p class="text-sm text-text-muted">The following plugins have new versions available. Check the ones you want to update and then click "Update Plugins".</p>
          
          <table class="w-full text-sm text-left border-collapse">
              <thead class="bg-gray-50 border-b border-border">
                  <tr>
                      <th class="w-10 px-4 py-2"><input type="checkbox" class="rounded" /></th>
                      <th class="px-4 py-2">Name</th>
                      <th class="px-4 py-2">Version</th>
                  </tr>
              </thead>
              <tbody class="divide-y divide-border">
                  <tr>
                      <td class="px-4 py-3"><input type="checkbox" class="rounded" /></td>
                      <td class="px-4 py-3 font-medium">Yoast SEO Clone</td>
                      <td class="px-4 py-3">You have version 2.4.1. Update to <strong>2.5.0</strong>.</td>
                  </tr>
                  <tr>
                      <td class="px-4 py-3"><input type="checkbox" class="rounded" /></td>
                      <td class="px-4 py-3 font-medium">Contact Form Builder</td>
                      <td class="px-4 py-3">You have version 5.8.2. Update to <strong>5.9.0</strong>.</td>
                  </tr>
              </tbody>
          </table>
          <button class="bg-primary text-white hover:bg-primary-hover px-4 py-2 text-sm font-medium rounded transition-colors">Update Plugins</button>
      </div>
  </div>

  <div class="bg-surface border border-border rounded-lg shadow-sm p-5">
      <div class="space-y-4">
          <h3 class="font-semibold text-text-main text-lg">Themes</h3>
          <p class="text-sm text-text-muted">Your themes are all up to date.</p>
      </div>
  </div>
</div>

<?php include '../includes/footer.php'; ?>