<?php
require_once '../config.php';
include '../includes/header.php';
?>

<div class="space-y-6 max-w-4xl">
  <div>
    <h2 class="text-2xl font-bold text-text-main">Tools</h2>
  </div>

  <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
    <div class="bg-surface border border-border rounded-lg shadow-sm p-5">
        <h3 class="font-semibold text-text-main mb-2">Available Tools</h3>
        <p class="text-sm text-text-muted mb-4">You currently have no custom tools available. The standard WordPress tools are listed below.</p>
    </div>

    <div class="bg-surface border border-border rounded-lg shadow-sm p-5">
        <h3 class="font-semibold text-text-main mb-2">Import</h3>
        <p class="text-sm text-text-muted mb-4">If you have posts or comments in another system, WordPress can import those into this site.</p>
        <button class="text-primary text-sm hover:underline border-none bg-transparent p-0">Run Importer</button>
    </div>

    <div class="bg-surface border border-border rounded-lg shadow-sm p-5">
        <h3 class="font-semibold text-text-main mb-2">Export</h3>
        <p class="text-sm text-text-muted mb-4">When you click the button below WordPress will create an XML file for you to save to your computer.</p>
        <button class="text-primary text-sm hover:underline border-none bg-transparent p-0">Export Content</button>
    </div>

    <div class="bg-surface border border-border rounded-lg shadow-sm p-5">
        <h3 class="font-semibold text-text-main mb-2">Site Health</h3>
        <p class="text-sm text-text-muted mb-4">Your site has critical issues that should be addressed as soon as possible to improve its performance and security.</p>
        <button class="text-primary text-sm hover:underline border-none bg-transparent p-0">View Site Health Screen</button>
    </div>
  </div>
</div>

<?php include '../includes/footer.php'; ?>