<?php
require_once '../config.php';
include '../includes/header.php';
?>
<div class="space-y-6 max-w-6xl">
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-text-main">Theme Settings</h2>
            <p class="text-sm text-text-muted mt-1">Configure your global theme options and typography.</p>
        </div>
        <?= ui_button('Save Options') ?>
    </div>

    <div class="bg-surface border border-border rounded-lg shadow-sm flex min-h-[600px] overflow-hidden">
        <!-- Vertical Tabs -->
        <div class="w-64 bg-gray-50 border-r border-border flex flex-col">
            <div class="p-4 border-b border-border font-semibold text-text-main text-sm">WoodMart Options</div>
            <div class="overflow-y-auto custom-scrollbar flex-1 py-2">
                <a href="#" class="block px-4 py-2 text-sm text-primary font-medium bg-white border-l-2 border-primary">General</a>
                <a href="#" class="block px-4 py-2 text-sm text-text-muted hover:bg-gray-100 hover:text-text-main border-l-2 border-transparent">Header</a>
                <a href="#" class="block px-4 py-2 text-sm text-text-muted hover:bg-gray-100 hover:text-text-main border-l-2 border-transparent">Page Title</a>
                <a href="#" class="block px-4 py-2 text-sm text-text-muted hover:bg-gray-100 hover:text-text-main border-l-2 border-transparent">Footer</a>
                <a href="#" class="block px-4 py-2 text-sm text-text-muted hover:bg-gray-100 hover:text-text-main border-l-2 border-transparent">Typography</a>
                <a href="#" class="block px-4 py-2 text-sm text-text-muted hover:bg-gray-100 hover:text-text-main border-l-2 border-transparent">Styles & Colors</a>
                <a href="#" class="block px-4 py-2 text-sm text-text-muted hover:bg-gray-100 hover:text-text-main border-l-2 border-transparent">Blog</a>
                <a href="#" class="block px-4 py-2 text-sm text-text-muted hover:bg-gray-100 hover:text-text-main border-l-2 border-transparent">Shop</a>
            </div>
        </div>

        <!-- Tab Content -->
        <div class="flex-1 p-6 space-y-6 bg-white">
            <h3 class="text-lg font-bold border-b border-border pb-2 mb-4">General Settings</h3>
            
            <div class="space-y-4 max-w-2xl">
                <div>
                    <label class="block text-sm font-medium text-text-main mb-1">Favicon image</label>
                    <div class="flex items-center gap-4">
                        <div class="w-16 h-16 bg-gray-100 border border-gray-300 rounded flex items-center justify-center text-xs text-gray-400">Preview</div>
                        <?= ui_button('Upload', ['variant' => 'secondary']) ?>
                    </div>
                </div>
                
                <hr class="border-border">
                
                <div>
                    <label class="block text-sm font-medium text-text-main mb-1">Mobile bottom navbar</label>
                    <select class="block w-full px-3 py-2 border border-border rounded-md text-sm bg-white">
                        <option>Enable</option>
                        <option>Disable</option>
                    </select>
                    <p class="text-xs text-text-muted mt-1">Sticky bottom navbar with useful links for mobile devices.</p>
                </div>

                <hr class="border-border">

                <div>
                    <label class="block text-sm font-medium text-text-main mb-1">Custom 404 Page</label>
                    <select class="block w-full px-3 py-2 border border-border rounded-md text-sm bg-white">
                        <option>Default Theme Page</option>
                        <option>Custom HTML Block</option>
                    </select>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include '../includes/footer.php'; ?>