<?php
require_once '../config.php';
include '../includes/header.php';

$type = $_GET['type'] ?? 'Category';
$title = $_GET['title'] ?? 'Categories';

$mockCategories = [
  ['id' => 1, 'name' => 'General', 'description' => 'General topics', 'slug' => 'general', 'count' => 5],
  ['id' => 2, 'name' => 'Updates', 'description' => 'Site updates', 'slug' => 'updates', 'count' => 2],
];
?>

<div class="space-y-6">
  <div class="mb-4">
    <h2 class="text-2xl font-bold text-text-main"><?= escape($title) ?></h2>
  </div>

  <div class="flex flex-col md:flex-row gap-8">
    <!-- Add New Form -->
    <div class="w-full md:w-1/3 space-y-4">
        <h3 class="font-semibold text-text-main">Add New <?= escape($type) ?></h3>
        <form class="space-y-4" method="POST" action="">
            <div class="mb-4">
              <label class="block text-sm font-medium text-text-main mb-1.5">Name</label>
              <input type="text" class="block w-full px-3 py-2 border border-border rounded-md text-sm placeholder-gray-400 focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary bg-white" />
              <p class="mt-1 text-sm text-text-muted">The name is how it appears on your site.</p>
            </div>
            <div class="mb-4">
              <label class="block text-sm font-medium text-text-main mb-1.5">Slug</label>
              <input type="text" class="block w-full px-3 py-2 border border-border rounded-md text-sm placeholder-gray-400 focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary bg-white" />
              <p class="mt-1 text-sm text-text-muted">The "slug" is the URL-friendly version of the name. It is usually all lowercase and contains only letters, numbers, and hyphens.</p>
            </div>

            <?php if ($type === 'Category'): ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-text-main mb-1.5">Parent Category</label>
                    <select class="block w-full px-3 py-2 border border-border rounded-md text-sm bg-white focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary">
                        <option>None</option>
                        <?php foreach ($mockCategories as $c): ?>
                            <option><?= escape($c['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            <?php endif; ?>

            <div class="mb-4">
              <label class="block text-sm font-medium text-text-main mb-1.5">Description</label>
              <textarea class="block w-full px-3 py-2 border border-border rounded-md text-sm focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary bg-white" rows="4"></textarea>
              <p class="mt-1 text-xs text-text-muted">The description is not prominent by default; however, some themes may show it.</p>
            </div>
            
            <button type="submit" class="bg-primary text-white hover:bg-primary-hover px-4 py-2 text-sm font-medium rounded transition-colors">Add New <?= escape($type) ?></button>
        </form>
    </div>

    <!-- Table List -->
    <div class="w-full md:w-2/3">
         <div class="bg-surface border border-border rounded-lg shadow-sm">
            <div class="p-3 border-b border-border bg-gray-50 flex justify-between items-center">
                <div class="flex gap-2">
                    <select class="border border-border rounded text-sm px-2 py-1 bg-white focus:outline-none">
                        <option>Bulk actions</option>
                        <option>Delete</option>
                    </select>
                    <button class="bg-white text-text-main border border-border hover:bg-gray-50 px-3 py-1 text-sm font-medium rounded transition-colors">Apply</button>
                </div>
                <input type="text" placeholder="Search <?= escape($title) ?>..." class="block px-3 py-1 border border-border rounded-md text-sm placeholder-gray-400 focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary bg-white" />
            </div>
            <div class="overflow-x-auto">
            <table class="w-full text-sm text-left">
                <thead class="text-xs text-text-muted uppercase border-b border-border">
                <tr>
                    <th class="w-10 px-4 py-3"><input type="checkbox" class="rounded" /></th>
                    <th class="px-4 py-3 font-medium">Name</th>
                    <th class="px-4 py-3 font-medium">Description</th>
                    <th class="px-4 py-3 font-medium">Slug</th>
                    <th class="px-4 py-3 font-medium text-right">Count</th>
                </tr>
                </thead>
                <tbody class="divide-y divide-border">
                <?php foreach ($mockCategories as $item): ?>
                    <tr class="hover:bg-gray-50 group">
                        <td class="px-4 py-3"><input type="checkbox" class="rounded" /></td>
                        <td class="px-4 py-3">
                            <strong class="text-primary block cursor-pointer"><?= escape($item['name']) ?></strong>
                            <div class="text-xs text-gray-400 invisible group-hover:visible flex gap-2 mt-1">
                                <button class="text-primary hover:underline bg-transparent border-none p-0 cursor-pointer">Edit</button> | 
                                <button class="text-primary hover:underline bg-transparent border-none p-0 cursor-pointer">Quick Edit</button> | 
                                <button class="text-red-500 hover:underline bg-transparent border-none p-0 cursor-pointer">Delete</button> | 
                                <button class="text-primary hover:underline bg-transparent border-none p-0 cursor-pointer">View</button>
                            </div>
                        </td>
                        <td class="px-4 py-3 text-text-muted"><?= escape($item['description']) ?></td>
                        <td class="px-4 py-3 text-text-muted"><?= escape($item['slug']) ?></td>
                        <td class="px-4 py-3 text-right">
                            <a href="#" class="text-primary hover:underline"><?= escape($item['count']) ?></a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            </div>
         </div>
    </div>
  </div>
</div>

<?php include '../includes/footer.php'; ?>