<?php
require_once '../config.php';
include '../includes/header.php';
?>
<div class="space-y-6">
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-text-main flex items-center gap-2">
                <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10-4.477 10-10 10zm0-2a8 8 0 100-16 8 8 0 000 16z"></path><path d="M12 16v-4"></path><path d="M12 8h.01"></path></svg>
                Site Kit
            </h2>
            <p class="text-sm text-text-muted mt-1">Search Console and Analytics overview.</p>
        </div>
    </div>
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <?= ui_card([
            'title' => 'Traffic Overview (Last 28 Days)',
            'body' => '<div class="h-48 flex items-end justify-between gap-2 border-b border-gray-100 pb-4 mb-4">
                <div class="w-1/6 bg-blue-100 hover:bg-blue-200 rounded-t h-1/4 transition-all"></div>
                <div class="w-1/6 bg-blue-200 hover:bg-blue-300 rounded-t h-2/4 transition-all"></div>
                <div class="w-1/6 bg-blue-300 hover:bg-blue-400 rounded-t h-1/3 transition-all"></div>
                <div class="w-1/6 bg-blue-400 hover:bg-blue-500 rounded-t h-3/4 transition-all"></div>
                <div class="w-1/6 bg-blue-500 hover:bg-blue-600 rounded-t h-full transition-all"></div>
            </div>
            <div class="flex justify-between text-center">
                <div><p class="text-2xl font-bold">12.4K</p><p class="text-xs text-text-muted">Users</p></div>
                <div><p class="text-2xl font-bold">28.1K</p><p class="text-xs text-text-muted">Sessions</p></div>
                <div><p class="text-2xl font-bold">54.2%</p><p class="text-xs text-text-muted">Bounce Rate</p></div>
            </div>'
        ]) ?>
        <?= ui_card([
            'title' => 'Search Funnel',
            'body' => '<div class="space-y-4">
                <div class="flex justify-between items-center border-b pb-2"><span class="text-text-muted">Impressions</span><span class="font-bold">145K</span></div>
                <div class="flex justify-between items-center border-b pb-2"><span class="text-text-muted">Clicks</span><span class="font-bold">4.2K</span></div>
                <div class="flex justify-between items-center"><span class="text-text-muted">Unique Visitors</span><span class="font-bold">3.8K</span></div>
            </div>'
        ]) ?>
    </div>
</div>
<?php include '../includes/footer.php'; ?>