<?php
require_once '../config.php';

$activeTab = $_GET['tab'] ?? 'general';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Save logic would go here
    header("Location: Settings.php?tab=$activeTab&msg=saved");
    exit;
}

include '../includes/header.php';
?>

<div class="max-w-5xl space-y-6">
    <div class="flex items-center justify-between mb-2">
        <h2 class="text-2xl font-bold text-text-main">Settings</h2>
    </div>

    <?php if(isset($_GET['msg']) && $_GET['msg'] == 'saved'): ?>
        <div class="bg-green-100 text-green-800 p-3 rounded text-sm border border-green-200">Settings saved successfully.</div>
    <?php endif; ?>

    <div class="flex flex-col md:flex-row gap-6">
        <div class="w-full md:w-56 shrink-0">
            <nav class="flex md:flex-col space-x-2 md:space-x-0 md:space-y-1 overflow-x-auto md:overflow-visible pb-2 md:pb-0">
                <?php 
                $tabs = ['General', 'Writing', 'Reading', 'Discussion', 'Media', 'Permalinks'];
                foreach($tabs as $tab) {
                    $id = strtolower($tab);
                    $isActive = $activeTab === $id;
                    $activeClasses = $isActive ? 'bg-primary/10 text-primary border-primary' : 'text-text-muted hover:bg-gray-100 hover:text-text-main border-transparent';
                    echo "<a href=\"Settings.php?tab=$id\" class=\"text-left font-medium px-3 py-2 rounded-md whitespace-nowrap transition-colors text-sm border-l-2 $activeClasses\">$tab</a>";
                }
                ?>
            </nav>
        </div>

        <div class="flex-1">
            <form action="Settings.php?tab=<?= escape($activeTab) ?>" method="POST">
                <div class="bg-surface border border-border rounded-lg shadow-sm mb-6 p-5">
                    <h3 class="font-semibold text-text-main text-lg mb-6 capitalize border-b border-border pb-2"><?= escape($activeTab) ?> Settings</h3>
                    
                    <?php if($activeTab == 'general'): ?>
                    <div class="space-y-6">
                        <div class="grid grid-cols-1 md:grid-cols-[200px_1fr] gap-4 items-center">
                            <label class="text-sm font-medium text-text-main">Site Title</label>
                            <input type="text" value="My PHP WP Clone" class="block w-full px-3 py-2 border border-border rounded-md text-sm focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary" />
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-[200px_1fr] gap-4 items-center">
                            <label class="text-sm font-medium text-text-main">Administration Email Address</label>
                            <input type="email" value="admin@example.com" class="block w-full px-3 py-2 border border-border rounded-md text-sm focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary" />
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="text-center py-10 text-text-muted">
                        <p>Settings for <?= escape($activeTab) ?> go here.</p>
                    </div>
                    <?php endif; ?>
                </div>

                <div class="flex justify-start">
                    <button type="submit" class="bg-primary text-white hover:bg-primary-hover px-4 py-2 text-sm font-medium rounded transition-colors">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>