<?php
require_once '../config.php';
include '../includes/header.php';

$products = [
    ['name' => 'T-Shirt Logo', 'sku' => 'TSH-01', 'stock' => 'In stock (45)', 'price' => '$18.00', 'cat' => 'Clothing'],
    ['name' => 'Hoodie with Zipper', 'sku' => 'HOO-02', 'stock' => 'Out of stock', 'price' => '$45.00', 'cat' => 'Clothing'],
    ['name' => 'Sunglasses', 'sku' => 'SUN-01', 'stock' => 'In stock (12)', 'price' => '$90.00', 'cat' => 'Accessories'],
];
?>
<div class="space-y-6">
    <div class="flex justify-between items-center gap-4">
        <div><h2 class="text-2xl font-bold text-text-main">Products</h2></div>
        <?= ui_button('Add New') ?>
    </div>
    <div class="bg-surface border border-border rounded-lg shadow-sm">
        <table class="w-full text-sm text-left">
            <thead class="bg-gray-50 border-b border-border text-xs text-text-muted uppercase">
                <tr>
                    <th class="px-6 py-3 w-16">Image</th>
                    <th class="px-6 py-3">Name</th>
                    <th class="px-6 py-3">SKU</th>
                    <th class="px-6 py-3">Stock</th>
                    <th class="px-6 py-3">Price</th>
                    <th class="px-6 py-3">Categories</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-border">
                <?php foreach($products as $p): ?>
                <tr class="hover:bg-gray-50 group">
                    <td class="px-6 py-3"><div class="w-10 h-10 bg-gray-200 border rounded"></div></td>
                    <td class="px-6 py-3">
                        <strong class="text-primary block cursor-pointer mb-1"><?= $p['name'] ?></strong>
                        <div class="text-xs text-gray-400 invisible group-hover:visible flex gap-2">
                            <span class="text-primary hover:underline">Edit</span> | <span class="text-red-500 hover:underline">Trash</span>
                        </div>
                    </td>
                    <td class="px-6 py-3 text-text-muted"><?= $p['sku'] ?></td>
                    <td class="px-6 py-3 <?= strpos($p['stock'], 'Out') !== false ? 'text-red-500' : 'text-green-600' ?>"><?= $p['stock'] ?></td>
                    <td class="px-6 py-3 font-medium"><?= $p['price'] ?></td>
                    <td class="px-6 py-3 text-text-muted"><?= $p['cat'] ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php include '../includes/footer.php'; ?>