<?php
require_once '../config.php';

// Handle deletion
if (isset($_POST['delete_id'])) {
    $stmt = $pdo->prepare("DELETE FROM posts WHERE id = ?");
    $stmt->execute([$_POST['delete_id']]);
    header("Location: PostsList.php?msg=deleted");
    exit;
}

// Fetch Posts
$stmt = $pdo->query("SELECT * FROM posts ORDER BY created_at DESC");
$posts = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="space-y-6">
    <div class="flex justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-text-main">Posts</h2>
            <p class="text-sm text-text-muted mt-1">Manage all your blog posts and articles.</p>
        </div>
        <div>
            <a href="PostEditor.php" class="bg-primary text-white hover:bg-primary-hover px-4 py-2 text-sm font-medium rounded transition-colors inline-flex items-center">
                <svg class="mr-2" width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
                Add New
            </a>
        </div>
    </div>

    <?php if(isset($_GET['msg']) && $_GET['msg'] == 'deleted'): ?>
        <div class="bg-green-100 text-green-800 p-3 rounded text-sm border border-green-200">Post deleted successfully.</div>
    <?php endif; ?>
    <?php if(isset($_GET['msg']) && $_GET['msg'] == 'saved'): ?>
        <div class="bg-green-100 text-green-800 p-3 rounded text-sm border border-green-200">Post saved successfully.</div>
    <?php endif; ?>

    <div class="bg-surface border border-border rounded-lg shadow-sm">
        <div class="overflow-x-auto">
            <table class="w-full text-sm text-left">
                <thead class="text-xs text-text-muted uppercase bg-gray-50 border-b border-border">
                    <tr>
                        <th class="px-6 py-3 font-medium">Title</th>
                        <th class="px-6 py-3 font-medium">Author</th>
                        <th class="px-6 py-3 font-medium">Status</th>
                        <th class="px-6 py-3 font-medium">Date</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-border">
                    <?php foreach($posts as $post): ?>
                    <tr class="hover:bg-gray-50 transition-colors group">
                        <td class="px-6 py-4">
                            <div class="font-medium text-primary cursor-pointer hover:underline mb-1">
                                <?= escape($post['title']) ?> 
                                <?php if($post['status'] == 'Draft'): ?>
                                    <span class="text-text-muted font-normal text-xs ml-1">— Draft</span>
                                <?php endif; ?>
                            </div>
                            <!-- Hover actions -->
                            <div class="text-xs text-gray-400 invisible group-hover:visible flex gap-2">
                                <a href="PostEditor.php?id=<?= $post['id'] ?>" class="text-primary hover:underline">Edit</a> | 
                                <form action="PostsList.php" method="POST" class="inline" onsubmit="return confirm('Are you sure?');">
                                    <input type="hidden" name="delete_id" value="<?= $post['id'] ?>">
                                    <button type="submit" class="text-red-500 hover:underline bg-transparent border-none p-0 cursor-pointer">Trash</button>
                                </form>
                            </div>
                        </td>
                        <td class="px-6 py-4 text-text-muted"><?= escape($post['author']) ?></td>
                        <td class="px-6 py-4">
                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium border <?= $post['status'] == 'Published' ? 'bg-green-100 text-green-800 border-green-200' : 'bg-gray-100 text-gray-800 border-gray-200' ?>">
                                <?= escape($post['status']) ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 text-text-muted">
                            <?= date('M j, Y', strtotime($post['created_at'])) ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    
                    <?php if(empty($posts)): ?>
                    <tr>
                        <td colspan="4" class="px-6 py-8 text-center text-text-muted">No posts found.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>