<?php
require_once '../config.php';

$post = ['id' => '', 'title' => '', 'content' => '', 'status' => 'Draft'];
$is_edit = false;

// Fetch post if ID is provided
if (isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM posts WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $fetched = $stmt->fetch();
    if ($fetched) {
        $post = $fetched;
        $is_edit = true;
    }
}

// Handle Form Submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $_POST['title'];
    $content = $_POST['content'];
    $status = isset($_POST['action']) && $_POST['action'] == 'quick_draft' ? 'Draft' : $_POST['status'];
    $id = $_POST['post_id'] ?? null;

    if ($id) {
        // Update existing
        $stmt = $pdo->prepare("UPDATE posts SET title = ?, content = ?, status = ? WHERE id = ?");
        $stmt->execute([$title, $content, $status, $id]);
    } else {
        // Insert new
        $stmt = $pdo->prepare("INSERT INTO posts (title, content, status) VALUES (?, ?, ?)");
        $stmt->execute([$title, $content, $status]);
        $id = $pdo->lastInsertId();
    }
    
    header("Location: PostsList.php?msg=saved");
    exit;
}

include '../includes/header.php';
?>

<div class="space-y-6 max-w-6xl mx-auto">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-2xl font-bold text-text-main"><?= $is_edit ? 'Edit Post' : 'Add New Post' ?></h2>
    </div>

    <form action="PostEditor.php" method="POST" class="flex flex-col lg:flex-row gap-6">
        <input type="hidden" name="post_id" value="<?= escape($post['id']) ?>">
        
        <!-- Main Content Area -->
        <div class="flex-1 space-y-4">
            <input type="text" name="title" value="<?= escape($post['title']) ?>" placeholder="Add title" required class="block w-full px-4 py-3 text-2xl font-medium border border-border rounded-md focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary" />
            
            <div class="border border-border rounded-md bg-white overflow-hidden shadow-sm flex flex-col h-[500px]">
                <div class="bg-gray-50 border-b border-border p-2 flex gap-1 items-center shrink-0">
                    <button type="button" class="px-2 h-8 text-sm text-gray-700 hover:bg-gray-200 rounded">Add Media</button>
                </div>
                <textarea name="content" class="flex-1 w-full p-4 resize-none focus:outline-none text-text-main leading-relaxed" placeholder="Start writing..."><?= escape($post['content']) ?></textarea>
            </div>
        </div>

        <!-- Sidebar Meta Boxes -->
        <div class="w-full lg:w-80 space-y-6 shrink-0">
            <div class="bg-surface border border-border rounded-lg shadow-sm">
                <div class="px-4 py-3 border-b border-border"><h3 class="font-semibold text-text-main m-0">Publish</h3></div>
                <div class="p-4 space-y-4 text-sm">
                    <div>
                        <label class="block text-text-muted mb-1">Status</label>
                        <select name="status" class="w-full border border-border rounded px-2 py-1 focus:outline-none focus:border-primary">
                            <option value="Draft" <?= $post['status'] == 'Draft' ? 'selected' : '' ?>>Draft</option>
                            <option value="Published" <?= $post['status'] == 'Published' ? 'selected' : '' ?>>Published</option>
                        </select>
                    </div>
                </div>
                <div class="p-4 bg-gray-50 border-t border-border flex justify-end rounded-b-lg">
                    <button type="submit" class="bg-primary text-white hover:bg-primary-hover px-4 py-2 text-sm font-medium rounded transition-colors">
                        <?= $is_edit ? 'Update' : 'Publish' ?>
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>

<?php include '../includes/footer.php'; ?>