<?php
require_once '../config.php';
include '../includes/header.php';

$plugins = [
    ['name' => 'Yoast SEO Clone', 'description' => 'Improves your site SEO.', 'version' => '2.4.1', 'author' => 'Team SEO', 'status' => 'Active'],
    ['name' => 'Contact Form Builder', 'description' => 'Simple but flexible form builder.', 'version' => '5.8.2', 'author' => 'FormCo', 'status' => 'Inactive'],
];
?>

<div class="space-y-6">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
        <div><h2 class="text-2xl font-bold text-text-main">Plugins</h2></div>
        <button class="bg-white text-text-main border border-border hover:bg-gray-50 px-4 py-2 text-sm font-medium rounded transition-colors">Add New</button>
    </div>

    <div class="bg-surface border border-border rounded-lg shadow-sm">
        <div class="overflow-x-auto">
            <table class="w-full text-sm text-left">
                <thead class="text-xs text-text-muted uppercase bg-gray-50/50 border-b border-border">
                    <tr>
                        <th class="px-6 py-3 font-medium w-1/4">Plugin</th>
                        <th class="px-6 py-3 font-medium">Description</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-border">
                    <?php foreach($plugins as $plugin): 
                        $isActive = $plugin['status'] == 'Active';
                        $bg = $isActive ? 'bg-blue-50/30' : 'bg-white';
                    ?>
                    <tr class="<?= $bg ?> hover:bg-gray-50/50 transition-colors">
                        <td class="px-6 py-4 align-top">
                            <div class="font-semibold text-text-main mb-1"><?= escape($plugin['name']) ?></div>
                            <div class="text-xs font-medium space-x-2 mt-2">
                                <?php if($isActive): ?>
                                    <span class="text-primary hover:underline cursor-pointer">Deactivate</span>
                                <?php else: ?>
                                    <span class="text-primary hover:underline cursor-pointer">Activate</span> |
                                    <span class="text-red-500 hover:underline cursor-pointer">Delete</span>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="px-6 py-4 align-top">
                            <p class="text-text-main mb-2"><?= escape($plugin['description']) ?></p>
                            <p class="text-xs text-text-muted">Version <?= escape($plugin['version']) ?> | By <?= escape($plugin['author']) ?></p>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>