<?php
require_once '../config.php';
include '../includes/header.php';

$pages = [
    ['title' => 'Home', 'author' => 'Admin', 'date' => '2023-10-01', 'status' => 'Published'],
    ['title' => 'About Us', 'author' => 'Admin', 'date' => '2023-10-02', 'status' => 'Published'],
    ['title' => 'Contact', 'author' => 'Admin', 'date' => '2023-10-05', 'status' => 'Published'],
    ['title' => 'Privacy Policy', 'author' => 'Admin', 'date' => '2023-10-10', 'status' => 'Draft'],
];
?>
<div class="space-y-6">
    <div class="flex justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-text-main">Pages</h2>
        </div>
        <?= ui_button('Add New Page') ?>
    </div>
    <div class="bg-surface border border-border rounded-lg shadow-sm">
        <table class="w-full text-sm text-left">
            <thead class="bg-gray-50 border-b border-border text-xs text-text-muted uppercase">
                <tr>
                    <th class="px-6 py-3">Title</th>
                    <th class="px-6 py-3">Author</th>
                    <th class="px-6 py-3">Date</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-border">
                <?php foreach($pages as $page): ?>
                <tr class="hover:bg-gray-50 group">
                    <td class="px-6 py-4">
                        <strong class="text-primary block cursor-pointer mb-1"><?= $page['title'] ?> <?= $page['status'] == 'Draft' ? '<span class="text-text-muted font-normal text-xs">— Draft</span>' : '' ?></strong>
                        <div class="text-xs text-gray-400 invisible group-hover:visible flex gap-2">
                            <span class="text-primary hover:underline cursor-pointer">Edit</span> | 
                            <span class="text-red-500 hover:underline cursor-pointer">Trash</span>
                        </div>
                    </td>
                    <td class="px-6 py-4 text-text-muted"><?= $page['author'] ?></td>
                    <td class="px-6 py-4 text-text-muted"><?= $page['date'] ?> <br> <?= $page['status'] ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php include '../includes/footer.php'; ?>