<?php
require_once '../config.php';
include '../includes/header.php';

$mockMedia = [
  ['id' => 1, 'url' => 'https://picsum.photos/id/10/400/400', 'filename' => 'image1.jpg'],
  ['id' => 2, 'url' => 'https://picsum.photos/id/20/400/400', 'filename' => 'image2.jpg'],
  ['id' => 3, 'url' => 'https://picsum.photos/id/30/400/400', 'filename' => 'image3.jpg'],
  ['id' => 4, 'url' => 'https://picsum.photos/id/40/400/400', 'filename' => 'image4.jpg'],
  ['id' => 5, 'url' => 'https://picsum.photos/id/50/400/400', 'filename' => 'image5.jpg'],
  ['id' => 6, 'url' => 'https://picsum.photos/id/60/400/400', 'filename' => 'image6.jpg'],
];
?>

<div class="space-y-6">
  <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
    <div>
      <h2 class="text-2xl font-bold text-text-main">Media Library</h2>
    </div>
    <div class="flex space-x-2">
      <button class="bg-white text-text-main border border-border hover:bg-gray-50 px-4 py-2 text-sm font-medium rounded transition-colors">Add New</button>
    </div>
  </div>

  <div class="flex gap-4 mb-4">
      <select class="border border-border rounded-md text-sm px-3 py-1.5 focus:outline-none focus:border-primary bg-white">
          <option>All media items</option>
          <option>Images</option>
          <option>Audio</option>
          <option>Video</option>
      </select>
      <select class="border border-border rounded-md text-sm px-3 py-1.5 focus:outline-none focus:border-primary bg-white">
          <option>All dates</option>
          <option>October 2023</option>
          <option>September 2023</option>
      </select>
  </div>

  <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4">
    <?php foreach ($mockMedia as $item): ?>
      <div class="relative group aspect-square border border-border bg-gray-100 rounded overflow-hidden shadow-sm cursor-pointer hover:shadow-md transition-shadow">
        <img src="<?= escape($item['url']) ?>" alt="<?= escape($item['filename']) ?>" class="w-full h-full object-cover" />
        <div class="absolute inset-0 bg-black/50 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center">
            <span class="text-white text-xs font-medium px-2 py-1 bg-black/50 rounded backdrop-blur-sm truncate max-w-[90%]">
                <?= escape($item['filename']) ?>
            </span>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<?php include '../includes/footer.php'; ?>