<?php
require_once '../config.php';
include '../includes/header.php';
$title = $_GET['title'] ?? 'Module Overview';
?>
<div class="space-y-6 max-w-5xl">
    <div class="flex justify-between items-center">
        <h2 class="text-2xl font-bold text-text-main"><?= escape($title) ?></h2>
        <?= ui_button('Save Settings') ?>
    </div>
    <div class="bg-surface border border-border rounded-lg shadow-sm p-6 flex flex-col items-center justify-center min-h-[400px] text-center">
        <svg class="text-gray-300 w-20 h-20 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path></svg>
        <h3 class="text-xl font-medium text-text-main mb-2">Welcome to <?= escape($title) ?></h3>
        <p class="text-text-muted max-w-md">This is a fully styled functional placeholder for the <b><?= escape($title) ?></b> module. In a real environment, this area would load specific module configurations, tables, and settings.</p>
    </div>
</div>
<?php include '../includes/footer.php'; ?>