<?php
require_once '../config.php';
include '../includes/header.php';
?>
<div class="space-y-6 max-w-5xl">
    <div class="flex justify-between items-center">
        <h2 class="text-2xl font-bold text-text-main flex items-center gap-2">
            <span class="w-6 h-6 bg-[#92003B] text-white rounded-full flex items-center justify-center text-xs font-bold">E</span>
            Elementor Settings
        </h2>
        <?= ui_button('Save Changes') ?>
    </div>
    <div class="flex flex-col md:flex-row gap-6">
        <div class="w-full md:w-56 shrink-0">
            <nav class="flex md:flex-col space-y-1">
                <a href="#" class="text-sm font-medium px-3 py-2 rounded-md bg-primary/10 text-primary border-l-2 border-primary">General</a>
                <a href="#" class="text-sm font-medium px-3 py-2 rounded-md text-text-muted hover:bg-gray-100 hover:text-text-main border-l-2 border-transparent">Integrations</a>
                <a href="#" class="text-sm font-medium px-3 py-2 rounded-md text-text-muted hover:bg-gray-100 hover:text-text-main border-l-2 border-transparent">Advanced</a>
                <a href="#" class="text-sm font-medium px-3 py-2 rounded-md text-text-muted hover:bg-gray-100 hover:text-text-main border-l-2 border-transparent">Features</a>
            </nav>
        </div>
        <div class="flex-1 space-y-6">
            <?= ui_card([
                'title' => 'Post Types',
                'body' => '<p class="text-sm text-text-muted mb-4">Select the post types you want to enable Elementor on.</p>
                <div class="space-y-2">
                    <label class="flex items-center gap-2 text-sm"><input type="checkbox" checked class="rounded border-gray-300 text-primary"> Posts</label>
                    <label class="flex items-center gap-2 text-sm"><input type="checkbox" checked class="rounded border-gray-300 text-primary"> Pages</label>
                    <label class="flex items-center gap-2 text-sm"><input type="checkbox" checked class="rounded border-gray-300 text-primary"> Products</label>
                </div>'
            ]) ?>
            <?= ui_card([
                'title' => 'Disable Default Colors',
                'body' => '<label class="flex items-center gap-2 text-sm"><input type="checkbox" class="rounded border-gray-300 text-primary"> Disable Default Colors</label>
                <p class="text-xs text-text-muted mt-2">Checking this box will disable Elementor\'s Default Colors, and make Elementor inherit the colors from your theme.</p>'
            ]) ?>
        </div>
    </div>
</div>
<?php include '../includes/footer.php'; ?>