<?php
require_once '../config.php';

// Fetch some real statistics from DB
$posts_count = $pdo->query("SELECT COUNT(*) FROM posts")->fetchColumn();
$users_count = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();

include '../includes/header.php';
?>

<div class="space-y-6">
    <div class="flex justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-text-main">Dashboard</h2>
            <p class="text-sm text-text-muted mt-1">Welcome back! Here's what's happening on your PHP/MySQL site.</p>
        </div>
    </div>

    <!-- Stats Grid -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
        <div class="bg-surface border border-border rounded-lg shadow-sm p-5 relative overflow-hidden">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-text-muted mb-1">Total Posts</p>
                    <h3 class="text-2xl font-bold text-text-main"><?= number_format($posts_count) ?></h3>
                </div>
                <div class="p-3 rounded-lg bg-blue-100 text-blue-600">
                    <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline></svg>
                </div>
            </div>
        </div>
        
        <div class="bg-surface border border-border rounded-lg shadow-sm p-5 relative overflow-hidden">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-text-muted mb-1">Active Users</p>
                    <h3 class="text-2xl font-bold text-text-main"><?= number_format($users_count) ?></h3>
                </div>
                <div class="p-3 rounded-lg bg-purple-100 text-purple-600">
                    <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle></svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Draft Form targeting PostEditor.php -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="bg-surface border border-border rounded-lg shadow-sm p-5 h-full">
            <h3 class="font-semibold text-text-main mb-4">Quick Draft</h3>
            <form action="PostEditor.php" method="POST" class="space-y-4">
                <input type="hidden" name="action" value="quick_draft">
                <div>
                    <input type="text" name="title" placeholder="Title" required class="block w-full px-3 py-2 border border-border rounded-md text-sm focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary" />
                </div>
                <div>
                    <textarea name="content" rows="4" placeholder="What's on your mind?" required class="block w-full px-3 py-2 border border-border rounded-md text-sm focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary"></textarea>
                </div>
                <button type="submit" class="bg-primary text-white hover:bg-primary-hover px-4 py-2 text-sm font-medium rounded transition-colors">Save Draft</button>
            </form>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>