<?php
require_once '../config.php';
include '../includes/header.php';

$mockComments = [
  [
    'id' => 1,
    'author' => 'Alice',
    'email' => 'alice@example.com',
    'avatar' => 'https://picsum.photos/id/64/100/100',
    'content' => 'Great content!',
    'date' => '2023-10-25',
    'status' => 'Approved',
    'postTitle' => 'Welcome to the site',
  ],
  [
    'id' => 2,
    'author' => 'Bob',
    'email' => 'bob@example.com',
    'avatar' => 'https://picsum.photos/id/65/100/100',
    'content' => 'Needs more info.',
    'date' => '2023-10-26',
    'status' => 'Pending',
    'postTitle' => 'Welcome to the site',
  ]
];
?>

<div class="space-y-6">
  <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
    <div>
      <h2 class="text-2xl font-bold text-text-main">Comments</h2>
    </div>
  </div>

  <div class="flex space-x-4 text-sm mb-2">
    <span class="text-primary font-medium cursor-pointer">All (<?= count($mockComments) ?>)</span>
    <span class="text-gray-300">|</span>
    <span class="text-primary hover:underline cursor-pointer">Pending (1)</span>
    <span class="text-gray-300">|</span>
    <span class="text-primary hover:underline cursor-pointer">Approved (2)</span>
    <span class="text-gray-300">|</span>
    <span class="text-primary hover:underline cursor-pointer">Spam (0)</span>
    <span class="text-gray-300">|</span>
    <span class="text-primary hover:underline cursor-pointer">Trash (0)</span>
  </div>

  <div class="bg-surface border border-border rounded-lg shadow-sm">
    <div class="p-3 border-b border-border bg-gray-50 flex gap-2">
        <select class="border border-border rounded text-sm px-2 py-1 bg-white">
            <option>Bulk actions</option>
            <option>Unapprove</option>
            <option>Approve</option>
            <option>Mark as Spam</option>
            <option>Move to Trash</option>
        </select>
        <button class="bg-white text-text-main border border-border hover:bg-gray-50 px-3 py-1 text-sm font-medium rounded transition-colors">Apply</button>
    </div>

    <div class="overflow-x-auto">
      <table class="w-full text-sm text-left">
        <thead class="text-xs text-text-muted uppercase border-b border-border">
          <tr>
            <th class="w-10 px-4 py-3"><input type="checkbox" class="rounded" /></th>
            <th class="px-4 py-3 font-medium w-1/4">Author</th>
            <th class="px-4 py-3 font-medium w-1/2">Comment</th>
            <th class="px-4 py-3 font-medium">In Response To</th>
          </tr>
        </thead>
        <tbody class="divide-y divide-border">
          <?php foreach ($mockComments as $comment): ?>
            <tr class="group <?= $comment['status'] === 'Pending' ? 'bg-yellow-50/50' : 'hover:bg-gray-50' ?>">
              <td class="px-4 py-4 align-top pt-5"><input type="checkbox" class="rounded" /></td>
              <td class="px-4 py-4 align-top">
                  <div class="flex gap-3">
                      <img src="<?= escape($comment['avatar']) ?>" alt="" class="w-10 h-10 rounded shadow-sm" />
                      <div>
                          <strong class="block text-text-main"><?= escape($comment['author']) ?></strong>
                          <a href="mailto:<?= escape($comment['email']) ?>" class="text-primary hover:underline text-xs block"><?= escape($comment['email']) ?></a>
                          <span class="text-xs text-gray-400 block"><?= escape($comment['status']) ?></span>
                      </div>
                  </div>
              </td>
              <td class="px-4 py-4 align-top">
                <p class="text-text-main mb-2">
                    Submitted on <a href="#" class="text-primary hover:underline"><?= escape($comment['date']) ?></a>
                </p>
                <p class="text-text-main mb-3 whitespace-pre-line"><?= escape($comment['content']) ?></p>
                
                <div class="text-xs text-gray-400 invisible group-hover:visible flex gap-2">
                    <?php if ($comment['status'] === 'Pending'): ?>
                        <button class="text-green-600 hover:underline bg-transparent border-none p-0 cursor-pointer">Approve</button>
                    <?php else: ?>
                        <button class="text-orange-500 hover:underline bg-transparent border-none p-0 cursor-pointer">Unapprove</button>
                    <?php endif; ?> | 
                    <button class="text-primary hover:underline bg-transparent border-none p-0 cursor-pointer">Reply</button> | 
                    <button class="text-primary hover:underline bg-transparent border-none p-0 cursor-pointer">Edit</button> | 
                    <button class="text-red-500 hover:underline bg-transparent border-none p-0 cursor-pointer">Spam</button> | 
                    <button class="text-red-500 hover:underline bg-transparent border-none p-0 cursor-pointer">Trash</button>
                </div>
              </td>
              <td class="px-4 py-4 align-top">
                <a href="#" class="text-primary hover:underline block mb-1 font-medium"><?= escape($comment['postTitle']) ?></a>
                <a href="#" class="text-text-muted hover:underline text-xs block">View Post</a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include '../includes/footer.php'; ?>