<?php
require_once '../config.php';
$activeTab = $_GET['tab'] ?? 'themes';
include '../includes/header.php';
?>

<div class="space-y-4">
    <div class="flex items-center justify-between">
        <h2 class="text-2xl font-bold text-text-main">Appearance</h2>
    </div>
      
    <div class="flex space-x-6 border-b border-border">
        <a href="Appearance.php?tab=themes" class="pb-3 text-sm font-medium <?= $activeTab == 'themes' ? 'border-b-2 border-primary text-primary' : 'text-text-muted hover:text-text-main' ?>">Themes</a>
        <a href="Appearance.php?tab=menus" class="pb-3 text-sm font-medium <?= $activeTab == 'menus' ? 'border-b-2 border-primary text-primary' : 'text-text-muted hover:text-text-main' ?>">Menus</a>
    </div>

    <?php if($activeTab == 'themes'): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mt-6">
            <div class="border border-border rounded-lg overflow-hidden bg-white shadow-sm group">
                <div class="relative aspect-[3/2] overflow-hidden bg-gray-100 flex items-center justify-center text-gray-500">
                    Active Theme Preview
                </div>
                <div class="p-4 flex justify-between items-center bg-gray-50 border-t border-border">
                    <div class="font-semibold text-text-main">Twenty Twenty-Four <span class="ml-2 text-xs font-normal text-white bg-gray-800 px-2 py-0.5 rounded">Active</span></div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="mt-6 flex flex-col md:flex-row gap-6">
            <div class="w-full md:w-1/3 space-y-4">
                <div class="bg-surface border border-border rounded-lg shadow-sm">
                    <div class="px-5 py-4 border-b border-border"><h3 class="font-semibold">Add menu items</h3></div>
                    <div class="p-4 text-sm text-text-muted">Select items to add to the menu.</div>
                </div>
            </div>
            <div class="w-full md:w-2/3">
                <div class="bg-surface border border-border rounded-lg shadow-sm">
                    <div class="bg-gray-50 p-4 border-b border-border flex justify-between items-center">
                        <div class="flex items-center gap-3">
                            <label class="text-sm font-medium">Menu Name</label>
                            <input type="text" value="Primary Menu" class="border border-border rounded px-3 py-1 text-sm" />
                        </div>
                        <button class="bg-primary text-white hover:bg-primary-hover px-4 py-2 text-sm font-medium rounded">Save Menu</button>
                    </div>
                    <div class="p-6 bg-gray-100/50 min-h-[300px]">
                        <h4 class="font-medium text-text-main mb-4">Menu Structure</h4>
                        <div class="space-y-2">
                            <div class="border border-gray-300 bg-white p-3 shadow-sm rounded">Home</div>
                            <div class="border border-gray-300 bg-white p-3 shadow-sm rounded">About Us</div>
                            <div class="border border-gray-300 bg-white p-3 shadow-sm rounded">Blog</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php include '../includes/footer.php'; ?>