<?php
require_once '../config.php';
include '../includes/header.php';
?>
<div class="space-y-6">
    <div class="flex justify-between items-center gap-4">
        <h2 class="text-2xl font-bold text-text-main">Analytics Dashboard</h2>
        <div class="flex gap-2">
            <select class="border border-border rounded text-sm px-3 py-2 bg-white"><option>Last 7 Days</option><option>Last 30 Days</option></select>
            <?= ui_button('Export Data', ['variant' => 'secondary']) ?>
        </div>
    </div>
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <?= ui_card(['body' => '<div class="text-text-muted mb-1 text-sm">Total Revenue</div><div class="text-2xl font-bold">$4,230.50</div><div class="text-green-500 text-xs mt-2">↑ 12.5%</div>']) ?>
        <?= ui_card(['body' => '<div class="text-text-muted mb-1 text-sm">Conversion Rate</div><div class="text-2xl font-bold">3.2%</div><div class="text-green-500 text-xs mt-2">↑ 0.4%</div>']) ?>
        <?= ui_card(['body' => '<div class="text-text-muted mb-1 text-sm">Sessions</div><div class="text-2xl font-bold">12,450</div><div class="text-red-500 text-xs mt-2">↓ 1.2%</div>']) ?>
        <?= ui_card(['body' => '<div class="text-text-muted mb-1 text-sm">Avg. Order Value</div><div class="text-2xl font-bold">$84.50</div><div class="text-green-500 text-xs mt-2">↑ 5.1%</div>']) ?>
    </div>
    <?= ui_card([
        'title' => 'Revenue vs Orders (Last 7 Days)',
        'body' => '<div class="h-64 w-full flex items-end gap-4 justify-between pt-4">
            <div class="w-full bg-blue-100 rounded-t h-1/4 hover:bg-blue-200 transition-colors"></div>
            <div class="w-full bg-blue-200 rounded-t h-2/4 hover:bg-blue-300 transition-colors"></div>
            <div class="w-full bg-blue-300 rounded-t h-1/3 hover:bg-blue-400 transition-colors"></div>
            <div class="w-full bg-blue-400 rounded-t h-3/4 hover:bg-blue-500 transition-colors"></div>
            <div class="w-full bg-blue-500 rounded-t h-full hover:bg-blue-600 transition-colors"></div>
            <div class="w-full bg-blue-300 rounded-t h-2/3 hover:bg-blue-400 transition-colors"></div>
            <div class="w-full bg-blue-400 rounded-t h-1/2 hover:bg-blue-500 transition-colors"></div>
        </div>
        <div class="flex justify-between text-xs text-text-muted mt-2">
            <span>Mon</span><span>Tue</span><span>Wed</span><span>Thu</span><span>Fri</span><span>Sat</span><span>Sun</span>
        </div>'
    ]) ?>
</div>
<?php include '../includes/footer.php'; ?>