<?php
$current_page = basename($_SERVER['PHP_SELF']);

function sidebar_link($url, $icon, $label, $badge = null) {
    global $current_page;
    $isActive = $current_page == $url;
    $bgClass = $isActive ? 'bg-[#273549] text-white' : 'text-gray-300 hover:bg-[#273549] hover:text-white';
    
    $html = '<a href="' . escape($url) . '" class="flex items-center px-3 py-1.5 text-[13px] font-medium rounded transition-colors ' . $bgClass . '">';
    $html .= '<span class="mr-3 text-gray-400">' . $icon . '</span>';
    $html .= '<span>' . escape($label) . '</span>';
    
    if ($badge) {
        $html .= '<span class="ml-auto bg-[#d63638] text-white text-[10px] font-bold px-1.5 py-0.5 rounded-full leading-none">' . $badge . '</span>';
    }
    
    $html .= '</a>';
    return $html;
}
?>
<aside class="fixed top-0 left-0 z-40 h-screen w-[220px] bg-[#1e293b] text-white transition-transform lg:translate-x-0 lg:static flex flex-col select-none overflow-y-auto">
    <div class="h-14 flex items-center px-4 bg-[#141b26] border-b border-gray-800 shrink-0">
        <div class="flex items-center gap-2 text-lg font-bold tracking-tight text-white">
            <div class="w-6 h-6 bg-primary rounded-full flex items-center justify-center shrink-0">
                <span class="text-white text-sm leading-none font-serif">W</span>
            </div>
            <span>WP Admin</span>
        </div>
    </div>

    <div class="flex-1 py-3 px-2 space-y-0.5 custom-scrollbar">
        <?= sidebar_link('Dashboard.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 20V10"></path><path d="M18 20V4"></path><path d="M6 20v-4"></path></svg>', 'Dashboard') ?>
        <?= sidebar_link('SiteKit.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10-4.477 10-10 10zm0-2a8 8 0 100-16 8 8 0 000 16z"></path><path d="M12 16v-4"></path><path d="M12 8h.01"></path></svg>', 'Site Kit') ?>
        
        <div class="my-2 border-t border-gray-700 mx-2"></div>

        <?= sidebar_link('PostsList.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M21.44 11.05l-9.19 9.19a6 6 0 0 1-8.49-8.49l9.19-9.19a4 4 0 0 1 5.66 5.66l-9.2 9.19a2 2 0 0 1-2.83-2.83l8.49-8.48"></path></svg>', 'Posts') ?>
        <?= sidebar_link('MediaLibrary.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><circle cx="8.5" cy="8.5" r="1.5"></circle><polyline points="21 15 16 10 5 21"></polyline></svg>', 'Media') ?>
        <?= sidebar_link('PagesList.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M13 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V9z"></path><polyline points="13 2 13 9 20 9"></polyline></svg>', 'Pages') ?>
        <?= sidebar_link('CommentsList.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg>', 'Comments', '7') ?>
        
        <div class="my-2 border-t border-gray-700 mx-2"></div>

        <?= sidebar_link('ShopMagic.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M20.24 12.24a6 6 0 0 0-8.49-8.49L5 10.5V19h8.5z"></path><line x1="16" y1="8" x2="2" y2="22"></line><line x1="17.5" y1="15" x2="9" y2="6.5"></line></svg>', 'ShopMagic') ?>
        <?= sidebar_link('Contact.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path><polyline points="22,6 12,13 2,6"></polyline></svg>', 'Contact', '1') ?>
        <?= sidebar_link('PhonePe.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"></path></svg>', 'PhonePe PG Support') ?>
        
        <div class="my-2 border-t border-gray-700 mx-2"></div>

        <?= sidebar_link('WoodMart.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="16"></line><line x1="8" y1="12" x2="16" y2="12"></line></svg>', 'WoodMart') ?>
        <?= sidebar_link('ThemeSettings.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><line x1="4" y1="21" x2="4" y2="14"></line><line x1="4" y1="10" x2="4" y2="3"></line><line x1="12" y1="21" x2="12" y2="12"></line><line x1="12" y1="8" x2="12" y2="3"></line><line x1="20" y1="21" x2="20" y2="16"></line><line x1="20" y1="12" x2="20" y2="3"></line><line x1="1" y1="14" x2="7" y2="14"></line><line x1="9" y1="8" x2="15" y2="8"></line><line x1="17" y1="16" x2="23" y2="16"></line></svg>', 'Theme settings') ?>
        <?= sidebar_link('Layouts.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><polygon points="12 2 2 7 12 12 22 7 12 2"></polygon><polyline points="2 17 12 22 22 17"></polyline><polyline points="2 12 12 17 22 12"></polyline></svg>', 'Layouts') ?>
        <?= sidebar_link('HTMLBlocks.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>', 'HTML Blocks') ?>
        <?= sidebar_link('Slides.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><line x1="3" y1="9" x2="21" y2="9"></line><line x1="9" y1="21" x2="9" y2="9"></line></svg>', 'Slides') ?>
        <?= sidebar_link('Sidebars.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><line x1="9" y1="3" x2="9" y2="21"></line></svg>', 'Sidebars') ?>
        <?= sidebar_link('Projects.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><rect x="2" y="7" width="20" height="14" rx="2" ry="2"></rect><path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16"></path></svg>', 'Projects') ?>

        <div class="my-2 border-t border-gray-700 mx-2"></div>

        <?= sidebar_link('WooCommerce.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"></path></svg>', 'WooCommerce') ?>
        <?= sidebar_link('ProductsList.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path><polyline points="3.27 6.96 12 12.01 20.73 6.96"></polyline><line x1="12" y1="22.08" x2="12" y2="12"></line></svg>', 'Products') ?>
        <?= sidebar_link('Payments.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><line x1="12" y1="1" x2="12" y2="23"></line><path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path></svg>', 'Payments') ?>
        <?= sidebar_link('Analytics.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><line x1="18" y1="20" x2="18" y2="10"></line><line x1="12" y1="20" x2="12" y2="4"></line><line x1="6" y1="20" x2="6" y2="14"></line></svg>', 'Analytics') ?>
        <?= sidebar_link('Marketing.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg>', 'Marketing') ?>

        <div class="my-2 border-t border-gray-700 mx-2"></div>

        <?= sidebar_link('Elementor.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><line x1="8" y1="6" x2="21" y2="6"></line><line x1="8" y1="12" x2="21" y2="12"></line><line x1="8" y1="18" x2="21" y2="18"></line><line x1="3" y1="6" x2="3.01" y2="6"></line><line x1="3" y1="12" x2="3.01" y2="12"></line><line x1="3" y1="18" x2="3.01" y2="18"></line></svg>', 'Elementor') ?>
        <?= sidebar_link('Templates.php', '<svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"></path></svg>', 'Templates') ?>
        
        <div class="h-4"></div>
    </div>
</aside>
<style>
/* Custom scrollbar for sidebar to match WP feel */
.custom-scrollbar::-webkit-scrollbar { width: 6px; }
.custom-scrollbar::-webkit-scrollbar-track { background: transparent; }
.custom-scrollbar::-webkit-scrollbar-thumb { background-color: rgba(255,255,255,0.1); border-radius: 10px; }
</style>
