<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>WP Clone Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        background: '#f0f0f1',
                        surface: '#ffffff',
                        border: '#e6e8eb',
                        primary: '#206bc4',
                        'primary-hover': '#1a569d',
                        text: { main: '#182433', muted: '#667382' }
                    },
                    fontFamily: {
                        sans: ['Inter', '-apple-system', 'BlinkMacSystemFont', 'Segoe UI', 'Roboto', 'sans-serif'],
                    }
                }
            }
        }

        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const backdrop = document.getElementById('sidebar-backdrop');
            sidebar.classList.toggle('-translate-x-full');
            backdrop.classList.toggle('hidden');
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #f0f0f1; color: #182433; }
    </style>
</head>
<body class="flex h-screen overflow-hidden bg-background font-sans">

<!-- Sidebar Backdrop for Mobile -->
<div id="sidebar-backdrop" class="fixed inset-0 bg-gray-900/50 z-30 hidden lg:hidden transition-opacity" onclick="toggleSidebar()"></div>

<?php include __DIR__ . '/sidebar.php'; ?>

<div class="flex-1 flex flex-col overflow-hidden relative w-full">
    <!-- Topbar -->
    <header class="h-16 bg-surface border-b border-border flex items-center justify-between px-4 lg:px-6 sticky top-0 z-20 shrink-0">
        <div class="flex items-center gap-3">
            <!-- Hamburger Menu Button (Mobile Only) -->
            <button onclick="toggleSidebar()" class="lg:hidden p-2 -ml-2 text-text-muted hover:bg-gray-100 rounded-md focus:outline-none">
                <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16"></path></svg>
            </button>

            <div class="hidden sm:flex relative w-48 md:w-64">
                    <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-text-muted">
                        <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>
                    </span>
                <input type="text" placeholder="Search..." class="block w-full pl-10 pr-3 py-1.5 border border-border rounded-md text-sm focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary bg-gray-50 transition-colors" />
            </div>
        </div>
        <div class="flex items-center space-x-4">
            <div class="flex items-center cursor-pointer ml-2">
                <img class="h-8 w-8 rounded-full border border-border object-cover shrink-0" src="https://picsum.photos/id/64/100/100" alt="Avatar" />
                <div class="hidden md:block ml-2 text-sm">
                    <span class="block font-medium text-text-main leading-tight">Admin User</span>
                </div>
            </div>
        </div>
    </header>

    <!-- Main Scrollable Area -->
    <main class="flex-1 overflow-x-hidden overflow-y-auto bg-background">
        <div class="container mx-auto px-4 sm:px-6 py-6 lg:max-w-[95%]">