<?php
// Set the API key from environment variable
$api_key = getenv('MAIL_API_KEY') ?: '1'; // Fallback if not set

$url = 'https://wala.guru/mail/';

// Helper: make base64 attachment from a file path
function make_base64_attachment(string $path, string $filename = null, string $mime = 'application/octet-stream'): array {
    if (!is_readable($path)) {
        throw new RuntimeException("Attachment not readable: $path");
    }
    $b64 = base64_encode(file_get_contents($path));
    return [
        'filename' => $filename ?: basename($path),
        'content'  => $b64,
        'type'     => $mime,
    ];
}


$data = [
    'smtp' => [
        'host' => 'wala.guru',
        'port' => 587,
        'secure' => 'tls',
        'auth' => true,
        'username' => 'no-reply@meghait.in',
        'password' => 'Megha@6448',
        'verify_tls' => true,
        'timeout' => 30,
//        'tls_peer_name'=> 'r1.dnspark.in'
    ],
    'message' => [
        'from' => 'Megha Enterprises <no-reply@meghait.in>',
        'reply_to' => 'support@meghait.in',
        'to' => ['princerk742@gmail.com'],
        'cc' => [],
        'bcc' => [],
        'subject' => 'Get in put',
        'html' => '<strong>Hello</strong> from the universal API',
        'text' => 'Hello from the universal API',
        'attachments' => [
            make_base64_attachment(__DIR__.'/test.txt', 'test.txt', 'text/plain'),
        ]
    ]
];

$json_data = json_encode($data);

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $api_key,
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Handle response (example: check for success)
if ($http_code === 200) {
    echo 'Email sent successfully: ' . $response . PHP_EOL;
} else {
    echo 'Error sending email. HTTP Code: ' . $http_code . ', Response: ' . $response . PHP_EOL;
}
?>